package com.yeejoin.amos;

import com.yeejoin.amos.patrol.mqtt.PatrolMqttListener;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.restful.config.JsonSerializerManage;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

/**
 * <pre>
 * 服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: YeeAMOSPatrolStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableJpaAuditing
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan(value = {"org.typroject", "com.yeejoin.amos"}, excludeFilters = {
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, classes = {JsonSerializerManage.class})})
@MapperScan(basePackages = {"com.yeejoin.amos.patrol.business.dao.mapper", "org.typroject.tyboot.core.auth.face.orm.dao", "com.yeejoin.amos.boot.biz.common.dao.mapper"})
public class PatrolApplication {

    private static final Logger logger = LoggerFactory.getLogger(PatrolApplication.class);


    @Bean
    @LoadBalanced
    RestTemplate initRestTemplate() {
        return new RestTemplate();
    }

    @Autowired
    private PatrolMqttListener patrolMqttListener;

    @Autowired
    private EmqKeeper emqKeeper;

    @Value("${patrol.topic}")
    private String patrolTopic;

    /**
     * 启动amosop-server
     *
     * @param args
     * @throws IOException
     * @throws URISyntaxException
     */
    public static void main(String[] args) throws UnknownHostException {
        logger.info("start Service..........");
        ConfigurableApplicationContext context = SpringApplication.run(PatrolApplication.class, args);
        GlobalExceptionHandler.setAlwaysOk(true);
        Environment env = context.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        GlobalExceptionHandler.setAlwaysOk(true);
        logger.info("\n----------------------------------------------------------\n\t" +
                "Application Amos-Biz-Boot is running! Access URLs:\n\t" +
                "Swagger文档: \thttp://" + ip + ":" + port + path + "/doc.html\n" +
                "----------------------------------------------------------");
    }

    /**
     * 初始化MQTT
     * @throws MqttException
     */
    @Bean
    void initMqtt() {
        try {
            emqKeeper.subscript(patrolTopic, 1, patrolMqttListener);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("EMQ初始化连接失败!");
        }
    }

}