package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.tdc.api.entity.TdcDrawing;
import com.yeejoin.amos.boot.module.tdc.api.service.ITdcDrawingService;

import com.yeejoin.amos.boot.module.tdc.biz.service.impl.TdcDrawingServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;


/**
 * @author duanwei
 * @date 2022-11-22
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/tdc-drawing")
public class TdcDrawingController extends BaseController {

    @Autowired
    ITdcDrawingService iTdcDrawingService;
    @Autowired
    TdcDrawingServiceImpl iTdcDrawingServiceImpl;


    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveTdcDrawing(HttpServletRequest request, @RequestBody TdcDrawing tdcDrawing) {
        return iTdcDrawingService.save(tdcDrawing);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel<Boolean>  deleteById(HttpServletRequest request, @PathVariable List<Long> id) {
        return ResponseHelper.buildResponse(iTdcDrawingService.removeByIds(id));
    }


    /**
     * 修改
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdTdcDrawing(HttpServletRequest request, @RequestBody TdcDrawing tdcDrawing) {
        return iTdcDrawingService.updateById(tdcDrawing);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public TdcDrawing selectById(HttpServletRequest request, @PathVariable Long id) {
        return iTdcDrawingService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<TdcDrawing> listPage(String pageNum, String pageSize,
                                      TdcDrawing tdcDrawing) {

        Page<TdcDrawing> pageBean;
        QueryWrapper<TdcDrawing> tdcDrawingQueryWrapper = new QueryWrapper<>();
        Class<? extends TdcDrawing> aClass = tdcDrawing.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(tdcDrawing);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(tdcDrawing);
                        tdcDrawingQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(tdcDrawing);
                        tdcDrawingQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(tdcDrawing);
                        tdcDrawingQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(tdcDrawing);
                        tdcDrawingQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<TdcDrawing> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iTdcDrawingService.page(pageBean, tdcDrawingQueryWrapper);
        return page;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "saveAttachment")
    @ApiOperation(httpMethod = "Post", value = "直接查询列表", notes = "直接查询列表")
    public ResponseModel<List<TdcDrawing>> saveAttachment(@RequestBody JSONObject attachment) {
        //当前登录用户信息
        AgencyUserModel userInfo = getUserInfo();
        return ResponseHelper.buildResponse(iTdcDrawingServiceImpl.saveAttachment(attachment, userInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/listInfo")
    @ApiOperation(httpMethod = "GET", value = "分页查询")
    public ResponseModel<IPage> listInfo(int current, int size) {
        IPage page = new Page();
        page.setSize(size);
        page.setCurrent(current);
        return ResponseHelper.buildResponse(iTdcDrawingService.page(page));
    }
}


