package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 
 *
 * @author litw
 * @date 2021-09-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="ElevatorAlarmDto", description="")
public class ElevatorAlarmDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "电梯注册码")
    private String registerCode;

    @ApiModelProperty(value = "原始故障编号")
    private String faultId;

    @ApiModelProperty(value = "故障发生时间")
    private Date startDate;

    @ApiModelProperty(value = "故障类型")
    private String type;

    /**
     * 故障类型名称
     */
    @ApiModelProperty(value = "故障类型名称")
    private String typeName;

    @ApiModelProperty(value = "处置状态。0：处置完成。1：故障发生 2：发出通知 3：处置响应 4：处置到场 5：误报")
    private Integer dealStatus;

    @ApiModelProperty(value = "处置时间")
    private Date dealDate;

    @ApiModelProperty(value = "处置人")
    private Integer dealPerson;

    @ApiModelProperty(value = "现场确认是否困人。0：不困人，1：困人")
    private Integer isTrap;

    @ApiModelProperty(value = "是否自恢复 0：否1：是")
    private Integer selfrepair;

    @ApiModelProperty(value = "故障发生时的总接触器吸合或是断开。0：吸合，1：断开")
    private Integer dealNote;

    @ApiModelProperty(value = "是否自恢复 0：否1：是")
    private Integer mainContactor;

    @ApiModelProperty(value = "故障发生时的运行接触器吸合或是断开。0：吸合，1：断开")
    private Integer runContactor;

    @ApiModelProperty(value = "故障发生时的安全回路是否断开 0：正常，1：断开")
    private Integer circuit;

    @ApiModelProperty(value = "故障发生时的轿厢运行状态。1：停止，2：运行")
    private Integer carStatus;

    @ApiModelProperty(value = "故障发生时的方向。1：无方向 2：上行 3：下行")
    private Integer direction;

    @ApiModelProperty(value = "故障发生时的轿厢是否在门区。1：轿厢在门区 0：轿厢在非门区")
    private Integer isZone;

    @ApiModelProperty(value = "故障发生时的当前物理楼层")
    private Integer floor;

    @ApiModelProperty(value = "故障发生时的关门到位 1：关门到位，0：无关门到位信号")
    private Integer doorStatus;

    @ApiModelProperty(value = "故障发生时的上极限是否动作 0:否，1：是")
    private Integer upLimit;

    @ApiModelProperty(value = "故障发生时的下极限是否动作 0:否，1：是")
    private Integer downLimit;

    @ApiModelProperty(value = "故障发生时的轿厢报警按钮是否动作 0:否，1：是")
    private Integer alarm;

    @ApiModelProperty(value = "累计运行小时数，保留到小数点后两位")
    private Double hours;

    @ApiModelProperty(value = "累计运行次数")
    private Integer runCount;

}
