package com.yeejoin.amos.boot.module.tzs.api.enums;

/**
 * 
 * <pre>
 * 电梯安全回路状态枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftCircuitStatusEnum.java, v 0.1 2021年9月29日 上午9:23:00 gwb Exp $
 */
public enum LiftCircuitStatusEnum{

	NORMAL(0,"正常"),
	BREAK (1,"断开");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftCircuitStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftCircuitStatusEnum getEnum(Integer code)
	{
		for (LiftCircuitStatusEnum liftCircuitStatusEnum : LiftCircuitStatusEnum.values())
		{
			if (liftCircuitStatusEnum.getCode().equals(code))
			{
				return liftCircuitStatusEnum;
			}
		}
		return null;
	}
}
