package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 注册单位工商信息表
 *
 * @author system_generator
 * @date 2022-08-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="RegUnitIcDto", description="注册单位工商信息表")
public class RegUnitIcDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "证件code")
    private String unitCode;

    @ApiModelProperty(value = "所属行业")
    private String industryName;

    @ApiModelProperty(value = "登记机关")
    private String registeredOrgan;

    @ApiModelProperty(value = "登记机关编码")
    private String registeredOrganCode;

    @ApiModelProperty(value = "核准时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date approvedDate;

    @ApiModelProperty(value = "经营状态：在业、吊销、注销、迁入、迁出、停业、清算")
    private String businessState;

   @ApiModelProperty(value = "经营状态code")
   private String businessStateCode;

}
