package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 液化气体气瓶充装信息-充装后复查
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_check")
@ApiModel(value="TzCylinderFillingCheck对象", description="液化气体气瓶充装信息-充装后复查")
public class CylinderFillingCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;




    @ApiModelProperty(value = "充装后复查ID")
    private String fillingCheckId;

    @ApiModelProperty(value = "充装量在规定范围内")
    private Integer withinScope;

    @ApiModelProperty(value = "瓶阀及其与瓶口连接的密封良好")
    private Integer sealedState;

    @ApiModelProperty(value = "瓶体未出现鼓包变形或泄露等严重缺陷")
    private Integer defective;

    @ApiModelProperty(value = "瓶体温度没有异常升高的迹象")
    private Integer abnormalTemperature;

    @ApiModelProperty(value = "气瓶粘贴警示标签和充装标签")
    private Integer warningSign;

    @ApiModelProperty(value = "液化气瓶充装量符合有关规定，充装后逐瓶称重")
    private String compliance;

    @ApiModelProperty(value = "检查人员姓名")
    private String inspector;

    @ApiModelProperty(value = "检查时间")
    private String inspectionDate;



    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "检查结果")
    private String checkResults;

    @ApiModelProperty(value = "不合格项")
    private String nonconformances;
}
