package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 气瓶检验信息
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_inspection")
@ApiModel(value="TzCylinderInspection对象", description="气瓶检验信息")
public class CylinderInspection extends BaseEntity {

    private static final long serialVersionUID = 1L;




    @ApiModelProperty(value = "检验单位")
    private String inspectionUnit;

    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "检验日期")
    private String inspectionDate;

    @ApiModelProperty(value = "下次检验日期")
    private String nextInspectionDate;

    @ApiModelProperty(value = "检验结果")
    private String inspectionResult;



    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "不合格报废数量")
    private String scrapQuantity;
}
