package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.CylinderUnitDataServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderUnitDataDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 企业总量统计表
 *
 * @author system_generator
 * @date 2022-03-04
 */
@RestController
@Api(tags = "企业总量统计表Api")
@RequestMapping(value = "/cylinder-unit-data")
public class CylinderUnitDataController extends BaseController {

    @Autowired
    CylinderUnitDataServiceImpl cylinderUnitDataServiceImpl;

    /**
     * 新增企业总量统计表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增企业总量统计表", notes = "新增企业总量统计表")
	public ResponseModel<CylinderUnitDataDto> save(@RequestBody CylinderUnitDataDto model) {
	    model = cylinderUnitDataServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新企业总量统计表", notes = "根据sequenceNbr更新企业总量统计表")
	public ResponseModel<CylinderUnitDataDto> updateBySequenceNbrCylinderUnitData(@RequestBody CylinderUnitDataDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderUnitDataServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除企业总量统计表", notes = "根据sequenceNbr删除企业总量统计表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderUnitDataServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个企业总量统计表",  notes = "根据sequenceNbr查询单个企业总量统计表")
	public ResponseModel<CylinderUnitDataDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderUnitDataServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "企业总量统计表分页查询",  notes = "企业总量统计表分页查询")
	public ResponseModel<Page<CylinderUnitDataDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderUnitDataDto> page = new Page<CylinderUnitDataDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderUnitDataServiceImpl.queryForCylinderUnitDataPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "企业总量统计表列表全部数据查询",   notes = "企业总量统计表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderUnitDataDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderUnitDataServiceImpl.queryForCylinderUnitDataList());
	}
}
