package com.yeejoin.amos.boot.module.jcs.api.mapper;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledTodyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledZhDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;

/**
* 警情接警记录 Mapper 接口
*
* @author tb
* @date 2021-06-17
*/
public interface AlertCalledMapper extends BaseMapper<AlertCalled> {

    /**
     * 接警情况统计-交接班用
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    Map<String, Integer> queryAlertStatusCount(@Param("beginDate") String beginDate, @Param("endDate") String endDate);

    List<AlertCalledZhDto> alertCalledListByAlertStatus(@Param("pageNum")Integer pageNum, @Param("pageSize")Integer pageSize,@Param("par")RequestData par);

    int  alertCalledListByAlertStatusCount(@Param("par")RequestData par);

    Integer AlertCalledcountTime(@Param("type")int type);

    List<AlertCalledTodyDto> getTodayAlertCalled();

    List<Map<String,String>> getContactName( );

    List<String> getAddress();

    List<AlertCalled> selectAllPage(Long current, Long size,
                                    Integer alertStatus,
                                    String alertTypeCode ,
                                    String alertSourceCode,
                                    String startTime,
                                    String endTime,
                                    String data,
                                    String lift);

    int selectAllCount(Integer alertStatus,
                       String alertTypeCode ,
                       String alertSourceCode,
                       String startTime,
                       String endTime);

    Integer AlertCalledcount(@Param("alertStatus")int alertStatus);

     //未结束灾情列表
    List<AlertCalled> AlertCalledStatusPage(@Param("current")Integer current, @Param("size")Integer size);
    
    Set<Map<String, Object>> getLocation();

}
