package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.converter.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author LiuLin
 * @date 2021-06-18.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "设备信息-气瓶", description = "设备信息-气瓶")
public class EquipInfoCylinderExcelDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    //基本信息
    @ApiModelProperty(value = "设备名称")
    @ExcelProperty(value = "设备名称", index = 0)
    @NotBlank(message = "设备名称不能为空")
    private String productName;

    @ApiModelProperty(value = "设备型号")
    @ExcelProperty(value = "设备型号", index = 1)
    @NotBlank(message = "设备型号不能为空")
    private String equType;

    @ApiModelProperty(value = "单位内部编号")
    @ExcelProperty(value = "单位内部编号", index = 2)
    @NotBlank(message = "单位内部编号不能为空")
    private String useInnerCode;

    @ApiModelProperty(value = "是否车用气瓶")
    @ExcelProperty(value = "是否车用气瓶", index = 3, converter = VehicleCylinderConverter.class)
    @NotBlank(message = "是否车用气瓶不能为空")
    private String whetherVehicleCylinder;

    @ApiModelProperty(value = "有无设备代码")
    @ExcelProperty(value = "有无设备代码", index = 4, converter = EquCodeTypeConverter.class)
    @NotBlank(message = "有无设备代码不能为空")
    private String equCodeType;

    @ApiModelProperty(value = "设备代码")
    @ExcelProperty(value = "设备代码", index = 5)
    private String equCode;//判断是否必填和位数

    @ApiModelProperty(value = "气瓶分类")
    @ExcelProperty(value = "气瓶分类", index = 6, converter = CylinderCategoryConverter.class)
    private String cylinderCategory;

    @ApiModelProperty(value = "设备总价值(万元)")
    @ExcelProperty(value = "设备总价值(万元)", index = 7)
    @NotBlank(message = "设备总价值(万元)不能为空")
    private String equPrice;


    //设计信息
    @ApiModelProperty(value = "设计单位统一社会信用代码")
    @ExcelProperty(value = "设计单位统一社会信用代码", index = 8)
    @NotBlank(message = "设计单位统一社会信用代码不能为空")
    private String designUnitCreditCode;

    @ApiModelProperty(value = "设计单位名称")
    @ExcelProperty(value = "设计单位名称", index = 9)
    @NotBlank(message = "设计单位名称不能为空")
    private String designUnitName;

    @ApiModelProperty(value = "设计许可编号")
    @ExcelProperty(value = "设计许可编号", index = 10)
    private String designLicenseNum;

    @ApiModelProperty(value = "设计使用年限(年)")
    @ExcelProperty(value = "设计使用年限(年)", index = 11)
    private String designUseDate;

    @ApiModelProperty(value = "设计日期")
    @ExcelProperty(value = "设计日期", index = 12)
    @DateTimeFormat("yyyy-MM-dd")
    private String designDate;

    @ApiModelProperty(value = "总图图号")
    @ExcelProperty(value = "总图图号", index = 13)
    private String drawingDo;

    @ApiModelProperty(value = "设计文件鉴定单位")
    @ExcelProperty(value = "设计文件鉴定单位", index = 14)
    private String appraisalUnit;

    @ApiModelProperty(value = "设计文件鉴定日期")
    @ExcelProperty(value = "设计文件鉴定日期", index = 15)
    @DateTimeFormat("yyyy-MM-dd")
    private String appraisalDate;

    //制造信息
    @ApiModelProperty(value = "制造单位统一社会信用代码")
    @ExcelProperty(value = "制造单位统一社会信用代码", index = 16)
    @NotBlank(message = "制造单位统一社会信用代码不能为空")
    private String produceUnitCreditCode;

    @ApiModelProperty(value = "制造单位名称")
    @ExcelProperty(value = "制造单位名称", index = 17)
    @NotBlank(message = "制造单位名称不能为空")
    private String produceUnitName;

    @ApiModelProperty(value = "制造许可编号")
    @ExcelProperty(value = "制造许可编号", index = 18)
    @NotBlank(message = "制造许可编号不能为空")
    private String produceLicenseNum;

    @ApiModelProperty(value = "出厂编号/产品编码")
    @ExcelProperty(value = "出厂编号/产品编码", index = 19)
    @NotBlank(message = "出厂编号/产品编码不能为空")
    private String factoryNum;

    @ApiModelProperty(value = "制造日期")
    @ExcelProperty(value = "制造日期", index = 20)
    @NotBlank(message = "制造日期不能为空")
    @DateTimeFormat("yyyy-MM-dd")
    private String produceDate;

    @ApiModelProperty(value = "是否进口")
    @ExcelProperty(value = "是否进口", index = 21, converter = ImportedConverter.class)
    private String imported;

    @ApiModelProperty(value = "制造国")
    @ExcelProperty(value = "制造国", index = 22)
    private String produceCountry;

    //检验检测
    @ApiModelProperty(value = "检测机构名称")
    @ExcelProperty(value = "检测机构名称", index = 23)
    @NotBlank(message = "检测机构名称不能为空")
    private String inspectOrgName;

    @ApiModelProperty(value = "检测机构代码")
    @ExcelProperty(value = "检测机构代码", index = 24)
    @NotBlank(message = "检测机构代码不能为空")
    private String inspectOrgCode;

    @ApiModelProperty(value = "检测人员名称")
    @ExcelProperty(value = "检测人员名称", index = 25)
    @NotBlank(message = "检测人员名称不能为空")
    private String inspectStaff;

    @ApiModelProperty(value = "检测日期")
    @ExcelProperty(value = "检测日期", index = 26)
    @NotBlank(message = "检测日期不能为空")
    @DateTimeFormat("yyyy-MM-dd")
    private String inspectDate;

    @ApiModelProperty(value = "下次检验日期")
    @ExcelProperty(value = "下次检验日期", index = 27)
    @NotBlank(message = "下次检验日期不能为空")
    @DateTimeFormat("yyyy-MM-dd")
    private String nextInspectDate;

    @ApiModelProperty(value = "检验报告编号")
    @ExcelProperty(value = "检验报告编号", index = 28)
    private String inspectReportNo;

    //技术参数
    @ExcelProperty(value = "额定质量(kg)", index = 29)
    @ApiModelProperty(value = "额定质量(kg)")
    private String ratedQuality;

    @ExcelProperty(value = "使用环境温度(℃)", index = 30)
    @ApiModelProperty(value = "使用环境温度(℃)")
    private String ambientTemperature;

    @ExcelProperty(value = "单瓶容积(m3)", index = 31)
    @ApiModelProperty(value = "单瓶容积(m3)")
    @NotBlank(message = "单瓶容积(m3)不能为空")
    private String singleBottleVolume;

    @ExcelProperty(value = "型号", index = 32)
    @ApiModelProperty(value = "型号")
    private String modelNumber;

    @ExcelProperty(value = "充装介质", index = 33)
    @ApiModelProperty(value = "充装介质")
    @NotBlank(message = "充装介质不能为空")
    private String chargingMedium;

    @ExcelProperty(value = "规格", index = 34)
    @ApiModelProperty(value = "规格")
    private String specification;

    @ExcelProperty(value = "外径", index = 35)
    @ApiModelProperty(value = "外径")
    private String outsideDiameter;

    @ExcelProperty(value = "壁厚", index = 36)
    @ApiModelProperty(value = "壁厚")
    private String wallThickness;

    @ExcelProperty(value = "长度", index = 37)
    @ApiModelProperty(value = "长度")
    private String length;

    @ExcelProperty(value = "公称工作压力(MPa)", index = 38)
    @ApiModelProperty(value = "公称工作压力(MPa)")
    @NotBlank(message = "公称工作压力(MPa)不能为空")
    private String nominalWorkingPressure;

    @ExcelProperty(value = "材料(管路)", index = 39)
    @ApiModelProperty(value = "材料(管路)")
    private String piping;

    @ExcelProperty(value = "无损检测方法(气瓶)", index = 40, converter = NondestructConverter.class)
    @ApiModelProperty(value = "无损检测方法(气瓶)")
    private String qpLossless;//5988

    @ExcelProperty(value = "材料(瓶体)", index = 41)
    @ApiModelProperty(value = "材料(瓶体)")
    private String bottleBody;

    @ExcelProperty(value = "材料(端塞)", index = 42)
    @ApiModelProperty(value = "材料(端塞)")
    private String endPlug;

    @ExcelProperty(value = "无损检测比例(管路)(%)", index = 43)
    @ApiModelProperty(value = "无损检测比例(管路)(%)")
    private String glRatio;

    @ExcelProperty(value = "无损检测比例(气瓶)(%)", index = 44)
    @ApiModelProperty(value = "无损检测比例(气瓶)(%)")
    private String qpRatio;

    @ExcelProperty(value = "无损检测方法(管路)", index = 45, converter = NondestructConverter.class)
    @ApiModelProperty(value = "无损检测方法(管路)")
    private String glLossless;

    @ExcelProperty(value = "耐压实验压力(气瓶)(Mpa)", index = 46)
    @ApiModelProperty(value = "耐压实验压力(气瓶)(Mpa)")
    private String qpPressure;

    @ExcelProperty(value = "耐压实验压力(管路)(Mpa)", index = 47)
    @ApiModelProperty(value = "耐压实验压力(管路)(Mpa)")
    private String glPressure;

    @ExcelProperty(value = "气密性试验压力(气瓶)(Mpa)", index = 48)
    @ApiModelProperty(value = "气密性试验压力(气瓶)(Mpa)")
    private String qpAirTightness;

    @ExcelProperty(value = "气体置换后压力(MPa)", index = 49)
    @ApiModelProperty(value = "气体置换后压力(MPa)")
    private String displacementPressure;

    @ExcelProperty(value = "热处理方式", index = 50)
    @ApiModelProperty(value = "热处理方式")
    private String heatTreatmentMethod;

    @ExcelProperty(value = "气密性实验压力(管路)(MPa)", index = 51)
    @ApiModelProperty(value = "气密性实验压力(管路)(MPa)")
    private String glAirTightness;

    @ExcelProperty(value = "气瓶安装位置", index = 52)
    @ApiModelProperty(value = "气瓶安装位置")
    private String installationPosition;

    @ExcelProperty(value = "瓶体内含氧量(%)", index = 53)
    @ApiModelProperty(value = "瓶体内含氧量(%)")
    private String oxygen;

    @ExcelProperty(value = "热处理温度(℃)", index = 54)
    @ApiModelProperty(value = "热处理温度(℃)")
    private String qpHeatTreatmentTemperature;

    /**
     * 信息化管理字段-信息化管理情况
     */
    @ExcelProperty(value = "信息化管理情况", index = 55, converter = InformationSituationConverter.class)
    private String informationSituation;

    /**
     * 信息化管理字段-二维码或者电子标签编号
     */
    @ExcelProperty(value = "二维码或者电子标签编号", index = 56)
    private String informationManageCode;

    @ExcelIgnore
    private List<?> fileData;
}