package com.yeejoin.amos.patrol.business.param;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.patrol.dao.entity.BasicEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.util.Date;

public class TaskInfoParam extends BasicEntity{
	
	private int depth; // 任务转发深度
	@ApiModelProperty("执行人名称")
	private String executor; // 当前执行人
	
	/**
	 * 执行人id
	 */
	@ApiModelProperty("执行人id")

	private String executorId;


	private Date factFinishTime; // 实际完成时间

	@Column(name="feedback_num")
	private int feedbackNum; // 回复个数

	@ApiModelProperty("完成时间")
	private Date finishTime; // 完成时间
	@ApiModelProperty("是否需要告警提示（1 通知 ； 2 不通知 ）")
	private String isWarn; // 是否需要告警提示

    //执行人部门
	private String  depId;
	
	
	public String getDepId() {
		return depId;
	}

	public void setDepId(String depId) {
		this.depId = depId;
	}

	@ApiModelProperty("任务可转发次数")
	private int maxDepth; // 任务最大转发深度

	private String orgCode; // 组织编码

	private Date publishTime; // 发布时间

	private String publisher; // 发布人id

	private String publisherName; // 发布人名称
	@ApiModelProperty("任务说明")
	private String remark; // 任务说明

	private int status; // 状态
	@ApiModelProperty("任务名称")
	private String title; // 任务名称

	@Temporal(TemporalType.TIMESTAMP)
	@ApiModelProperty("告警提示时间")
	private Date warnTime; // 告警提示时间
	
	@ApiModelProperty("拍照配置（[{\"isMust\":\"是\",\"name\":\"my任务名称拍照\"}]）")
	private JSONArray config;
	
	@ApiModelProperty("检查记录ID")
	private Long checkId;

	
	public Long getCheckId() {
		return checkId;
	}

	public void setCheckId(Long checkId) {
		this.checkId = checkId;
	}

	public int getDepth() {
		return this.depth;
	}

	public void setDepth(int depth) {
		this.depth = depth;
	}

	public String getExecutor() {
		return this.executor;
	}

	public void setExecutor(String executor) {
		this.executor = executor;
	}

	public Date getFactFinishTime() {
		return this.factFinishTime;
	}

	public void setFactFinishTime(Date factFinishTime) {
		this.factFinishTime = factFinishTime;
	}

	public int getFeedbackNum() {
		return this.feedbackNum;
	}

	public void setFeedbackNum(int feedbackNum) {
		this.feedbackNum = feedbackNum;
	}

	public Date getFinishTime() {
		return this.finishTime;
	}

	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	public String getIsWarn() {
		return this.isWarn;
	}

	public void setIsWarn(String isWarn) {
		this.isWarn = isWarn;
	}

	public int getMaxDepth() {
		return this.maxDepth;
	}

	public void setMaxDepth(int maxDepth) {
		this.maxDepth = maxDepth;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public Date getPublishTime() {
		return this.publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public String getPublisher() {
		return this.publisher;
	}

	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	public String getPublisherName() {
		return this.publisherName;
	}

	public void setPublisherName(String publisherName) {
		this.publisherName = publisherName;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public int getStatus() {
		return this.status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getWarnTime() {
		return this.warnTime;
	}

	public void setWarnTime(Date warnTime) {
		this.warnTime = warnTime;
	}

	public JSONArray getConfig() {
		return config;
	}

	public void setConfig(JSONArray config) {
		this.config = config;
	}

	public String getExecutorId() {
		return executorId;
	}

	public void setExecutorId(String executorId) {
		this.executorId = executorId;
	}
}
