package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.RunRecord;
import com.yeejoin.amos.boot.module.jxiop.api.dto.TreeDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MonitorFanIndicator;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitorFanIndicatorImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;
import java.util.stream.Collectors;

@RestController
@Api(tags = "大屏相关API")
@RequestMapping(value = "/monitorFanIdx")
public class MonitorFanIdxController extends BaseController {

    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicatorImpl;

    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicator;


    @Autowired
    StationBasicMapper stationBasicMapper;

    @Autowired
    CommonServiceImpl commonService;

    @Value("${gl.sum.column}")
    String sumColumn;

    @Value("${gl.avg.column}")
    String avgColumn;

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据设备编号、场站id、前段展示模块、系统类型查询表数据")
    @GetMapping("/getFanIdxInfoByPage")
    public ResponseModel<IPage<IndexDto>> getFanIdxInfoByPage(@RequestParam(value = "equipNum", required = false) String equipNum,
                                                              @RequestParam(value = "stationId", required = false) String stationId,
                                                              @RequestParam(value = "frontModule", required = false) String frontModule,
                                                              @RequestParam(value = "systemType", required = false) String systemType,
                                                              @RequestParam(value = "current", required = false) int current,
                                                              @RequestParam(value = "size", required = false) int size) {
        return ResponseHelper.buildResponse(monitorFanIndicator.getFanIdxInfoByPage(equipNum, stationId, frontModule, current, size, systemType));
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "左侧树API")
    @GetMapping("/getTreeInfo")
    public ResponseModel<TreeDto> getTreeInfo(@RequestParam(value = "sequenceNbr", required = true) String sequenceNbr) {
        return ResponseHelper.buildResponse(monitorFanIndicator.getTreeInfo(sequenceNbr));
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "风机布置图 - 风机状态列表")
    @GetMapping("/getFanStatusList")
    public ResponseModel<IPage<IndexDto>> getFanStatusList(@RequestParam(value = "stationId", required = false) String stationId,
                                                           @RequestParam(value = "current", required = false) int current,
                                                           @RequestParam(value = "size", required = false) int size) {
        List<IndexDto> fanStatusList = monitorFanIndicator.getFanStatusList(stationId);
        Page<IndexDto> page = new Page<>(current, size);
        List<IndexDto> collect = fanStatusList.stream()
                .skip((long) (current - 1) * size)
                .limit(size)
                .collect(Collectors.toList());
        page.setTotal(fanStatusList.size());
        page.setRecords(collect);
        return ResponseHelper.buildResponse(page);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "风机布置图 - 风机数量")
    @GetMapping("/getFanNum")
    public ResponseModel<Integer> getFanNum(@RequestParam(value = "stationId", required = false) String stationId) {
        Integer num = monitorFanIndicator.getFanNum(stationId);
        return ResponseHelper.buildResponse(num);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "风机布置图 - 实时监控表计仪表盘数据")
    @GetMapping("/getFanDataByType")
    public ResponseModel<Map<String, String>> getFanDataByType(@RequestParam(value = "stationId", required = false) String stationId,
                                                   @RequestParam(value = "equipNum", required = false) String equipNum,
                                                   @RequestParam(value = "frontModule", required = false) String frontModule,
                                                   @RequestParam(value = "typeName", required = false) String typeName) {
        String num = monitorFanIndicator.getFanDataByType(stationId, equipNum, frontModule, typeName);
        Map<String, String> map = new HashMap<>();
        map.put("value", num);
        return ResponseHelper.buildResponse(map);
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "风机布置图 - 风机状态统计")
    @GetMapping("/getFanStatusStatistics")
    public ResponseModel<IPage<IndexDto>> getFanStatusStatistics(@RequestParam(value = "stationId", required = false) String stationId,
                                                                 @RequestParam(value = "current", required = false) int current,
                                                                 @RequestParam(value = "size", required = false) int size) {
        List<IndexDto> fanStatusStatistics = monitorFanIndicator.getFanStatusStatistics(stationId);
        Page<IndexDto> page = new Page<>(current, size);
        List<IndexDto> collect = fanStatusStatistics.stream()
                .skip((long) (current - 1) * size)
                .limit(size)
                .collect(Collectors.toList());
        page.setTotal(fanStatusStatistics.size());
        page.setRecords(collect);
        return ResponseHelper.buildResponse(page);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "风机布置图 - 风机基础信息")
    @GetMapping("/getFanBasicInfoByEquipNum")
    public ResponseModel<IndexDto> getFanBasicInfoByEquipNum(@RequestParam(value = "equipNum", required = false) String equipNum,
                                                             @RequestParam(value = "stationId", required = false) String stationId) {
        return ResponseHelper.buildResponse(monitorFanIndicator.getFanBasicInfoByEquipNum(equipNum, stationId));
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取当前表记的实时温度")
    @GetMapping("/getRealTimeTemperature")
    public ResponseModel<HashMap<String, List<String>>> getRealTimeTemperature(@RequestParam(value = "equipNum", required = false) String equipNum,
                                                                               @RequestParam(value = "stationId", required = false) String stationId,
                                                                               @RequestParam(value = "frontModule", required = false) String frontModule) {
     return ResponseHelper.buildResponse(monitorFanIndicator.getRealTimeTemperature(equipNum, stationId, frontModule))   ;
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "风机布置图-总概览")
    @GetMapping("/overview")
    public ResponseModel<IPage<Map<String, Object>>> getData(@RequestParam(value = "stationId", required = true)String stationId) {


        StationBasic stationBasic = stationBasicMapper.selectById(stationId);
        String gatewayId = stationBasic.getFanGatewayId();
        String [] sumColumns = new String[]{"日发电量","月发电量","年发电量"};
        String [] avgColumns = new String[]{"有功功率","瞬时风速"};
        List<String> columnList = Arrays.asList(sumColumns);
        List<String> columnLists = Arrays.asList(avgColumns);
        Map<String, Object> columnMap = new HashMap<>();


        for (String column : columnList) {
            Double result = commonService.getTotalByIndicatior(gatewayId, column);
            columnMap.put(column, result);
        }
        for (String column : columnLists) {
            Double result = commonService.getAvgvalueByIndicatior(gatewayId, column);
            columnMap.put(column, result);
        }

        String num = monitorFanIndicator.getFJCount(gatewayId);
        columnMap.put("风机台数",num);

        Double capacityl = commonService.getStationCapactityByStationWerks(stationBasic.getStationNumber());
        columnMap.put("装机容量",capacityl);


        List<Map<String,Object>> objects = new ArrayList<>();
        Map<String, Object> data = new HashMap<>();
        data.put("title",Float.valueOf(columnMap.get("装机容量").toString()));
        objects.add(data);
        Map<String, Object> data1 = new HashMap<>();
        data1.put("title",Float.valueOf(columnMap.get("日发电量").toString()));
        objects.add(data1);
        Map<String, Object> data2 = new HashMap<>();
        data2.put("title",columnMap.get("风机台数").toString().replace(".0",""));
        objects.add(data2);
        Map<String, Object> data3 = new HashMap<>();
        data3.put("title",Float.valueOf(columnMap.get("月发电量").toString()));
        objects.add(data3);
        Map<String, Object> data4 = new HashMap<>();
        data4.put("title",Float.valueOf(columnMap.get("瞬时风速").toString()));
        objects.add(data4);
        Map<String, Object> data5 = new HashMap<>();
        data5.put("title",Float.valueOf(columnMap.get("年发电量").toString()));
        objects.add(data5);
        Map<String, Object> data6 = new HashMap<>();
        data6.put("title",Float.valueOf(columnMap.get("有功功率").toString()));
        objects.add(data6);
        Map<String, Object> data7 = new HashMap<>();
        data7.put("title",7.47);
        objects.add(data7);

        IPage<Map<String,Object>> result = new Page<>();
        result.setRecords(objects);
        result.setCurrent(1);
        result.setTotal(objects.size());

        return ResponseHelper.buildResponse(result);
    }



    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "概览-全站风速功率曲线")
    @GetMapping("/overviewWindSpeed")
    public ResponseModel<Map<String, Object>> getOverviewWindSpeed(@RequestParam(value = "stationId", required = true)String stationId) {
        StationBasic stationBasic = stationBasicMapper.selectById(stationId);
        String gatewayId = stationBasic.getFanGatewayId();
        Map<String, Object> detailsWindSpeed = monitorFanIndicator.getDetailsWindSpeedAll(gatewayId);

        return ResponseHelper.buildResponse(detailsWindSpeed);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "风机详情-风速功率曲线")
    @GetMapping("/detailsWindSpeed")
    public ResponseModel<Map<String, Object>> getDetailsWindSpeed(@RequestParam(value = "stationId", required = true)String stationId,String name) {
        name = name + "风机";
        StationBasic stationBasic = stationBasicMapper.selectById(stationId);
        String gatewayId = stationBasic.getFanGatewayId();
        Map<String, Object> detailsWindSpeed = monitorFanIndicator.getDetailsWindSpeed(gatewayId, name);

        return ResponseHelper.buildResponse(detailsWindSpeed);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "状态监控")
    @GetMapping("/statusMonitoring")
    public ResponseModel<IPage<Map<String, Object>>> getStatusMonitoring(@RequestParam(value = "stationId", required = true)String stationId,String equipNum,String systemType) {
        StationBasic stationBasic = stationBasicMapper.selectById(stationId);
        String gatewayId = stationBasic.getFanGatewayId();
        List<Map<String, Object>> statusMonitoring = monitorFanIndicator.getStatusMonitoring(gatewayId, equipNum, systemType);
        IPage<Map<String,Object>> result = new Page<>();
        result.setRecords(statusMonitoring);
        result.setCurrent(1);
        result.setTotal(statusMonitoring.size());
        return ResponseHelper.buildResponse(result);
    }


}
