package com.yeejoin.amos.boot.module.elevator.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 警情填报业务数据项
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="RepairConsultDto", description="警情填报业务数据项")
public class RepairConsultDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "警情id或者保修单id")
    private Long parentId;

    @ApiModelProperty(value = "类型，0为故障报修，1为投诉咨询描述，2接警，3派遣，4抵达")
    private String type;

    @ApiModelProperty(value = "警情阶段")
    private String alertStatus;

    @ApiModelProperty(value = "保修人或咨询人姓名")
    private String contactUser;

    @ApiModelProperty(value = "保修人或咨询人联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "记录描述")
    private String description;

    @ApiModelProperty(value = "警情阶段code")
    private String alertStageCode;

    @ApiModelProperty(value = "阶段附件")
    private String attachment;

}
