package com.yeejoin.amos.boot.module.elevator.biz.controller;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.elevator.api.dto.TzsJgBasicInfoDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.PageParam;
import com.yeejoin.amos.boot.module.elevator.api.service.ITzsJgService;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 特种设备监管controller
 */
@RestController
@Api(tags = "特种设备监管Api")
@RequestMapping(value = "/tzs-jg-api")
public class TzsJGController {

	@Autowired
	ITzsJgService iTzsJgService;

	/**
	 * 查询监管设备列表
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "查询监管设备列表", notes = "查询监管设备列表")
	public ResponseModel<IPage<TzsJgBasicInfoDto>> page(PageParam pageParam, TzsJgBasicInfoDto tzsJgBasicInfoDto) {
		return ResponseHelper.buildResponse(iTzsJgService.page(pageParam, tzsJgBasicInfoDto));
	}

	/**
	 * 查询监管设备详情
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/{code}")
	@ApiOperation(httpMethod = "GET", value = "查询监管设备详情表", notes = "查询监管设备详情")
	public ResponseModel<TzsJgBasicInfoDto> detail(@PathVariable String code) {
		return ResponseHelper.buildResponse(iTzsJgService.detail(code));
	}
}
