package com.yeejoin.amos.boot.module.elevator.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.elevator.flc.biz.service.impl.EquipmentUseInfoServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.EquipmentUseInfoDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 设备使用信息表
 *
 * @author system_generator
 * @date 2022-01-05
 */
@RestController
@Api(tags = "设备使用信息表Api")
@RequestMapping(value = "/equipment-use-info")
public class EquipmentUseInfoController extends BaseController {

    @Autowired
    EquipmentUseInfoServiceImpl equipmentUseInfoServiceImpl;

    /**
     * 新增设备使用信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增设备使用信息表", notes = "新增设备使用信息表")
	public ResponseModel<EquipmentUseInfoDto> save(@RequestBody EquipmentUseInfoDto model) {
	    model = equipmentUseInfoServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新设备使用信息表", notes = "根据sequenceNbr更新设备使用信息表")
	public ResponseModel<EquipmentUseInfoDto> updateBySequenceNbrEquipmentUseInfo(@RequestBody EquipmentUseInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(equipmentUseInfoServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除设备使用信息表", notes = "根据sequenceNbr删除设备使用信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(equipmentUseInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个设备使用信息表",  notes = "根据sequenceNbr查询单个设备使用信息表")
	public ResponseModel<EquipmentUseInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(equipmentUseInfoServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "设备使用信息表分页查询",  notes = "设备使用信息表分页查询")
	public ResponseModel<Page<EquipmentUseInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<EquipmentUseInfoDto> page = new Page<EquipmentUseInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(equipmentUseInfoServiceImpl.queryForEquipmentUseInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "设备使用信息表列表全部数据查询",   notes = "设备使用信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<EquipmentUseInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(equipmentUseInfoServiceImpl.queryForEquipmentUseInfoList());
	}
}
