package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.yeejoin.amos.boot.module.tcm.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzBaseUnitLicence;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.TzBaseUnitLicenceServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@Api(tags = "企业许可数据信息Api")
@RequestMapping(value = "/baseUnitLicence", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TzBaseUnitLicenceController {

    @Autowired
    TzBaseUnitLicenceServiceImpl baseUnitLicenceService;

    /**
     * 根据企业名称查询许可信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/licences", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "根据企业名称查询许可信息", notes = "根据企业名称查询许可信息")
    public ResponseModel<List<TzBaseUnitLicence>> getLicenceByCompanyName(@RequestBody List<String> companyNames) {
        return  ResponseHelper.buildResponse(baseUnitLicenceService.getLicenceByCompanyName(companyNames));
    }

    /**
     * 根据企业统一信用代码查询许可信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/licences", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "POST", value = "根据企业名称查询许可信息", notes = "根据企业名称查询许可信息")
    public ResponseModel<List<TzBaseUnitLicence>> getLicenceByUnitCode(@RequestParam String unitCode) {
        return  ResponseHelper.buildResponse(baseUnitLicenceService.getLicenceByUnitCode(unitCode));
    }
}
