package com.yeejoin.equipmanage.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.equipmanage.common.utils.*;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@Api(tags = "组态需求 -- API")
@RequestMapping(value = "/configure", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ConfigureController extends AbstractBaseController {


    @Autowired
    private FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    private IEquipmentSpecificAlarmService equipmentSpecificAlarmService;

    @Autowired
    private IFireFightingSystemService iFireFightingSystemService;

    @Autowired
    private IotFeign iotFeign;

    @PersonIdentify
    @RequestMapping(value = "/alarmLogPage", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", produces = "application/json;charset=UTF-8", notes = "列表分页查询")
    public ResponseModel pageQuery(@RequestParam(required = false) String system, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        List<CommonRequest> queryRequests = new ArrayList<>();
        CommonRequest request7 = new CommonRequest();
        request7.setName("system");
        request7.setValue(StringUtil.isNotEmpty(system) ? StringUtils.trimToNull(system) : null);
        queryRequests.add(request7);
        if (!ValidationUtil.isEmpty(reginParams.getPersonIdentity())) {
            CommonRequest request13 = new CommonRequest();
            request13.setName("bizOrgCode");
            request13.setValue(StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null);
            queryRequests.add(request13);
        }
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        return CommonResponseUtil.success(equipmentSpecificAlarmService.pageQuery(param));
    }

    @PersonIdentify
    @RequestMapping(value = "/equipStatusCount", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "系统设备状态统计", produces = "application/json;charset=UTF-8", notes = "系统设备状态统计")
    public ResponseModel equipStatusCount(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(equipmentSpecificAlarmService.equipStatusCount(hashMap));
    }

    @PersonIdentify
    @RequestMapping(value = "/equipAlarmLine", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "系统近一周告警趋势图", produces = "application/json;charset=UTF-8", notes = "系统近一周告警趋势图")
    public ResponseModel equipAlarmLine(@RequestParam(required = false) String systemCode, @RequestParam(required = false) String indexKeys) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        if (StringUtils.isNotBlank(indexKeys)) {
            hashMap.put("indexKeys", indexKeys.split(","));
        }
        return CommonResponseUtil.success(equipmentSpecificAlarmService.equipAlarmLine(hashMap));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取系统告警信息")
    @GetMapping("/getSystemAlarmInfo")
    public ResponseModel getSystemAlarmInfo(CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        if (StringUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getSystemAlarmInfo(page, bizOrgCode));
    }


    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取设备告警待确认和未处理信息（根据系统编码查询）")
    @GetMapping("/getEquipAlarmInfoNum")
    public ResponseModel getEquipAlarmInfoNum(@RequestParam(required = false) String systemCode) {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getEquipAlarmInfoNum(systemCode, bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取消防力量信息（队伍值班等(专职)）")
    @GetMapping("/getFireTeamInfoBy116")
    public ResponseModel getFireTeamInfoBy116() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getFireTeamInfoBy116(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取消防力量信息（队伍值班等(志愿消防队)）")
    @GetMapping("/getFireTeamInfoBy117")
    public ResponseModel getFireTeamInfoBy117() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getFireTeamInfoBy117(bizOrgCode));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "消防车辆信息")
    @GetMapping("/getFireCarInfo")
    public ResponseModel getFireCarInfo() {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        return CommonResponseUtil.success(fireFightingSystemMapper.getFireCarInfo(bizOrgCode));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控页面消防车辆信息")
    @GetMapping("/getFireCarInfoByWL")
    public ResponseModel getFireCarInfoByWL(CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        if (StringUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        Page<Map<String, Object>> fireCarInfoByWL = fireFightingSystemMapper.getFireCarInfoByWL(page, bizOrgCode);
        if (!CollectionUtils.isEmpty(fireCarInfoByWL.getRecords())) {
            List<Map<String, Object>> records = fireCarInfoByWL.getRecords();
            records.forEach(item -> {
                String prefix = null;
                String suffix = null;
                String iotCode = item.get("iot_code").toString();
                if (iotCode.length() > 8) {
                    prefix = iotCode.substring(0, 8);
                    suffix = iotCode.substring(8);
                } else {
                    throw new BadRequest("装备物联编码错误，请确认！");
                }
                String nowStrLong = DateUtils.getNowStrLong();
                Date sevenDay = DateUtils.dateAddDays(null, -7);
                String seven = DateUtils.convertDateToString(sevenDay, DateUtils.DATE_TIME_PATTERN);
                ResponseModel sevenEntity = null;
                try {
                    sevenEntity = iotFeign.selectList(getAppKey(), getProduct(), getToken(), seven, nowStrLong, prefix, suffix, "FireCar_Start");
                   } catch (Exception e) {
                    e.printStackTrace();
                }
                if (200 == sevenEntity.getStatus()) {
                    String json1 = JSON.toJSONString(sevenEntity.getResult());
                    List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                    List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey("FireCar_Start") && t.get("FireCar_Start").equals("true"))).collect(Collectors.toList());
                    int num = collect.size();
                    item.put("count", num);
                }
                if (item.containsKey("carStateDate") && !ObjectUtils.isEmpty(item.get("carStateDate"))) {
                    try {
                        Date carStateDate = DateUtils.dateParse(item.get("carStateDate").toString(), "yyyy-MM-dd'T'HH:mm:ss");
                        String s = DateUtils.dateFormat(carStateDate, DateUtils.DATE_TIME_PATTERN);
                        item.put("carStateDate", s);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return CommonResponseUtil.success(fireCarInfoByWL);
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "概览水源信息")
    @GetMapping("/getWaterInfo")
    public ResponseModel getWaterInfo(CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(fireFightingSystemMapper.getWaterInfo(page, bizOrgCode, null));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "概览稳压泵信息")
    @GetMapping("/getPressurePumpInfo")
    public ResponseModel getPressurePumpInfo(CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        if (StringUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        Page<Map<String, Object>> pressurePumpInfo = fireFightingSystemMapper.getPressurePumpInfo(page, bizOrgCode, null);
        pressurePumpInfo.getRecords().stream().map(item -> {
            item.put("startAndStopNum", 0);
            item.put("update_time", "--");
            item.put("equipment_index_name", "--");
            String prefix = null;
            String suffix = null;
            String iotCode = item.get("iot_code").toString();
            if (iotCode.length() > 8) {
                prefix = iotCode.substring(0, 8);
                suffix = iotCode.substring(8);
            } else {
                throw new BadRequest("装备物联编码错误，请确认！");
            }

            String nowStrLong = DateUtils.getNowStrLong();
            Date startDate = DateUtils.dateAddMinutes(null, -4);
            String startDateStr = DateUtils.convertDateToString(startDate, DateUtils.DATE_TIME_PATTERN);
            ResponseModel entity1 = null;
            ResponseModel entity2 = null;
            try {
                entity1 = iotFeign.selectList(getAppKey(), getProduct(), getToken(), startDateStr, nowStrLong, prefix, suffix, "FHS_PressurePump_Start");
                entity2 = iotFeign.selectList(getAppKey(), getProduct(), getToken(), startDateStr, nowStrLong, prefix, suffix, "FHS_PressurePump_Stop");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (200 == entity1.getStatus() && 200 == entity2.getStatus()) {
                String json1 = JSON.toJSONString(entity1.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                String json2 = JSON.toJSONString(entity2.getResult());
                List<Map<String, String>> listObject2 = (List<Map<String, String>>) JSONArray.parse(json2);
                listObject1.addAll(listObject2);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey("FHS_PressurePump_Start") && t.get("FHS_PressurePump_Start").equals("true")) || (t.containsKey("FHS_PressurePump_Stop") && t.get("FHS_PressurePump_Stop").equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("startAndStopNum", num);
            }
            item.put("stateDesc", (Integer) item.get("startAndStopNum") <= 1 && Integer.parseInt(String.valueOf(item.get("isAlarm"))) == 0 ? "正常" : "异常");
            item.put("normalNum", (Integer) item.get("startAndStopNum") <= 1 ? 1 : 0);
            item.put("unNormalNum", (Integer) item.get("startAndStopNum") <= 1 ? 0 : 1);
            Map<String, String> stateMap = fireFightingSystemMapper.queryPressureNowStateBySpecificId((Long) item.get("id"));
            if (!ObjectUtils.isEmpty(stateMap) && stateMap.containsKey("update_date") && stateMap.containsKey("equipment_index_name")) {
                item.put("update_time", String.valueOf(stateMap.get("update_date")).replaceAll("T", " "));
                item.put("equipment_index_name", stateMap.get("equipment_index_name"));
            }
            return item;
        }).collect(Collectors.toList());
        return CommonResponseUtil.success(pressurePumpInfo);
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "消防给水3小稳压泵信息")
    @GetMapping("/getPressurePumpInfo3Small")
    public ResponseModel getPressurePumpInfo3Small(@RequestParam(required = false) String systemCode) {
        ReginParams reginParams = getSelectedOrgInfo();
        String bizOrgCode = !ValidationUtil.isEmpty(reginParams.getPersonIdentity()) && StringUtil.isNotEmpty(reginParams.getPersonIdentity().getBizOrgCode()) ? reginParams.getPersonIdentity().getBizOrgCode() : null;
        List<Map<String, Object>> pressurePumpInfo = fireFightingSystemMapper.getPressurePumpInfo3Small(bizOrgCode, systemCode);
        Map<String, Integer> resultMap = new HashMap<>();
        resultMap.put("total", pressurePumpInfo.size());
        resultMap.put("normalNum", 0);
        resultMap.put("unNormalNum", 0);

        pressurePumpInfo.stream().map(item -> {
            item.put("startAndStopNum", 0);
            item.put("update_time", "--");
            item.put("equipment_index_name", "--");
            String prefix = null;
            String suffix = null;
            String iotCode = item.get("iot_code").toString();
            if (iotCode.length() > 8) {
                prefix = iotCode.substring(0, 8);
                suffix = iotCode.substring(8);
            } else {
                throw new BadRequest("装备物联编码错误，请确认！");
            }

            String nowStrLong = DateUtils.getNowStrLong();
            Date startDate = DateUtils.dateAddMinutes(null, -4);
            String startDateStr = DateUtils.convertDateToString(startDate, DateUtils.DATE_TIME_PATTERN);
            ResponseModel entity1 = null;
            ResponseModel entity2 = null;
            try {
                entity1 = iotFeign.selectList(getAppKey(), getProduct(), getToken(), startDateStr, nowStrLong, prefix, suffix, "FHS_PressurePump_Start");
                entity2 = iotFeign.selectList(getAppKey(), getProduct(), getToken(), startDateStr, nowStrLong, prefix, suffix, "FHS_PressurePump_Stop");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (200 == entity1.getStatus() && 200 == entity2.getStatus()) {
                String json1 = JSON.toJSONString(entity1.getResult());
                List<Map<String, String>> listObject1 = (List<Map<String, String>>) JSONArray.parse(json1);
                String json2 = JSON.toJSONString(entity2.getResult());
                List<Map<String, String>> listObject2 = (List<Map<String, String>>) JSONArray.parse(json2);
                listObject1.addAll(listObject2);
                List<Map<String, String>> collect = listObject1.stream().filter(t -> (t.containsKey("FHS_PressurePump_Start") && t.get("FHS_PressurePump_Start").equals("true")) || (t.containsKey("FHS_PressurePump_Stop") && t.get("FHS_PressurePump_Stop").equals("true"))).collect(Collectors.toList());
                int num = collect.size();
                item.put("startAndStopNum", num);
            }
            resultMap.put("normalNum", (Integer) item.get("startAndStopNum") <= 1 && Integer.parseInt(String.valueOf(item.get("isAlarm"))) == 0 ? (resultMap.get("normalNum") + 1) : resultMap.get("normalNum"));
            resultMap.put("unNormalNum", (Integer) item.get("startAndStopNum") > 1 || Integer.parseInt(String.valueOf(item.get("isAlarm"))) > 0  ? (resultMap.get("unNormalNum") + 1) : resultMap.get("unNormalNum"));
            return item;
        }).collect(Collectors.toList());
        return CommonResponseUtil.success(resultMap);
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "3小水源信息")
    @GetMapping("/getSmallWaterInfo")
    public ResponseModel getSmallWaterInfo(@RequestParam(required = false) String systemCode, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);

        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(iFireFightingSystemService.getSmallWaterInfo(page, hashMap));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "获取系统名称（根据系统编码查询）")
    @GetMapping("/getSystemName")
    public ResponseModel getEquipSystemName(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemName(hashMap));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "获取系统工作状态（根据系统编码查询）")
    @GetMapping("/getSystemStatus")
    public ResponseModel getEquipSystemStatus(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemStatus(hashMap));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取系统近一月告警设备top5（根据系统编码查询）")
    @GetMapping("/getAlarmOneMonth")
    public ResponseModel getSpecificAlarmOneMonthTOP(@RequestParam(required = false) String systemCode) {
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.equipAlarmTOP(hashMap));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取系统设备状态（根据系统编码查询）")
    @GetMapping("/getEquipmentState")
    public ResponseModel getEquipmentState(@RequestParam(required = false) String systemCode, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        Page result = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        HashMap<String, Object> hashMap = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
        if (!ValidationUtil.isEmpty(personIdentity)) {
            String bizOrgCode = personIdentity.getBizOrgCode();
            if (StringUtils.isNotBlank(bizOrgCode)) {
                hashMap.put("bizOrgCode", bizOrgCode);
            }
            if (bizOrgCode == null) {
                return CommonResponseUtil.success(null);
            }
        }
        if (StringUtils.isNotBlank(systemCode)) {
            hashMap.put("systemCode", systemCode);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.equipmentState(result, hashMap));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-获取某站下装备数量、摄像头数量")
    @GetMapping("/statisticsByStation")
    public ResponseModel statisticsByStation(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.statisticsByStation(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-获取某站下今日告警设备")
    @GetMapping("/todayAlarmEquipment")
    public ResponseModel todayAlarmEquipment(@RequestParam(required = false) String bizOrgCode) {
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.todayAlarmEquipment(bizOrgCode));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-获取某站下今日告警信息")
    @GetMapping("/todayAlarmMessage")
    public ResponseModel todayAlarmMessage(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.todayAlarmMessage(bizOrgCode));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-获取某站下未消除的告警设备")
    @GetMapping("/todayAlarmUnEliminateEquipment")
    public ResponseModel todayAlarmUnEliminateEquipment(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.todayAlarmUnEliminateEquipment(bizOrgCode));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-获取某站下待确认的告警信息")
    @GetMapping("/todayAlarmUnEliminateMessage")
    public ResponseModel todayAlarmUnEliminateMessage(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.todayAlarmUnEliminateMessage(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-获取某站下近一月的告警信息")
    @GetMapping("/monthAlarm")
    public ResponseModel monthAlarm(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.monthAlarm(bizOrgCode));
    }
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-获取某站下近一年告警统计")
    @GetMapping("/yearsAlarm")
    public ResponseModel yearsAlarm(@RequestParam(required = false) String bizOrgCode) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.yearsAlarm(bizOrgCode));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "物联监控大屏3大-检测告警记录")
    @GetMapping("/alarmList")
    public ResponseModel alarmList(@RequestParam(required = false) String bizOrgCode, CommonPageable commonPageable) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        Page<Map<String, Object>> mapPage = iFireFightingSystemService.alarmList(page, bizOrgCode);
        for (Map<String, Object> record : mapPage.getRecords()) {
            record.put("createDate", ObjectUtils.isEmpty(record.get("createDate")) ? "" :String.valueOf(record.get("createDate")).replaceAll("T", " "));
        }
        return CommonResponseUtil.success(mapPage);
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipList")
    @ApiOperation(httpMethod = "GET", value = "装备列表-用于站端查看信息卡", notes = "装备列表-用于站端查看信息卡")
    public ResponseModel equipList(CommonPageable commonPageable, @RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        if (commonPageable.getPageNumber() == 0) {
            commonPageable.setPageNumber(1);
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        Page page = new Page<>(commonPageable.getPageNumber(), commonPageable.getPageSize());
        return CommonResponseUtil.success(iFireFightingSystemService.equipList(page, bizOrgCode));
    }


    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/iotMonthReport")
    @ApiOperation(httpMethod = "GET", value = "物联报表-月", notes = "物联报表-月")
    public ResponseModel iotMonthReport(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
                                   @RequestParam(value = "startDate") String startDate,
                                   @RequestParam(value = "endDate") String endDate) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.iotMonthReport(bizOrgCode, startDate, endDate));
    }


    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/iotWeekReport")
    @ApiOperation(httpMethod = "GET", value = "物联报表-周", notes = "物联报表-周")
    public ResponseModel iotWeekReport(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
                                   @RequestParam(value = "startDate") String startDate,
                                   @RequestParam(value = "endDate") String endDate) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.iotWeekReport(bizOrgCode, startDate, endDate));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/iotDayReport")
    @ApiOperation(httpMethod = "GET", value = "物联报表-日", notes = "物联报表-日")
    public ResponseModel iotDayReport(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
                                       @RequestParam(value = "startDate") String startDate,
                                       @RequestParam(value = "endDate") String endDate) {

        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)){
            return CommonResponseUtil.success(null);
        }
        return CommonResponseUtil.success(iFireFightingSystemService.iotDayReport(bizOrgCode, startDate, endDate));
    }


    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEquipExpiryStatistics")
    @ApiOperation(httpMethod = "GET", value = "4小概览-韶山-临期设备统计", notes = "4小概览-韶山-临期设备统计")
    public ResponseModel getEquipExpiryStatistics(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
                                      @ApiParam("临期天数-近多少天") @RequestParam(value = "expiryDayNum", required = false) Integer expiryDayNum) {
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        expiryDayNum = Objects.isNull(expiryDayNum) ? 60 : expiryDayNum;
        return CommonResponseUtil.success(iFireFightingSystemService.getEquipExpiryStatistics(bizOrgCode, expiryDayNum));
    }


    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEquipExpiryListByPage")
    @ApiOperation(httpMethod = "GET", value = "4小概览-韶山-临期设备列表", notes = "4小概览-韶山-临期设备列表")
    public ResponseModel getEquipExpiryListByPage(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode,
                                                  @ApiParam("临期天数-近多少天") @RequestParam(value = "expiryDayNum", required = false) Integer expiryDayNum,
                                                  @RequestParam(value = "pageSize") Integer pageSize,
                                                  @RequestParam(value = "pageNum") Integer pageNum) {
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        expiryDayNum = Objects.isNull(expiryDayNum) ? 60 : expiryDayNum;
        Page page = new Page(pageNum, pageSize);
        return CommonResponseUtil.success(iFireFightingSystemService.getEquipExpiryListByPage(bizOrgCode, expiryDayNum, page));
    }


    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getStockEquipStatistics")
    @ApiOperation(httpMethod = "GET", value = "4小概览-韶山-报废设备统计", notes = "4小概览-韶山-报废设备统计")
    public ResponseModel getStockEquipStatistics(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        if (ObjectUtils.isEmpty(bizOrgCode)) {
            return CommonResponseUtil.success(null);
        }
        //  重复列表组件只支持分页，所以组装数据
        Page page = new Page(1, 4);
        page.setTotal(4);
        page.setRecords(iFireFightingSystemService.getStockEquipStatistics(bizOrgCode));
        return CommonResponseUtil.success(page);
    }
}
