package com.yeejoin.amos.boot.module.tdc.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author xxz
 */
@Data
@Accessors(chain = true)
@TableName("tdc_submit_record")
@ApiModel(value="SubmitRecord对象", description="提交记录")
public class SubmitRecord {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @ApiModelProperty(value = "填报人")
    private String submitPeople;

    @ApiModelProperty(value = "机构code")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构名称")
    private String amosOrgName;

    @ApiModelProperty(value = "填报时间")
    private Date submitTime;

    @ApiModelProperty(value = "校验批次号")
    private String batchNo;
}
