package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 特种设备基本信息-维保备案信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_maintenance_info")
@ApiModel(value="TmJgMaintenanceInfo对象", description="特种设备基本信息-维保备案信息")
public class MaintenanceInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备唯一标识码")

    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "维保单位统一社会信用代码")
    private String meUnitCreditCode;

    @ApiModelProperty(value = "维保单位名称")
    private String meUnitName;

    @ApiModelProperty(value = "维保合同备案ID")
    private String repairInformId;

    @ApiModelProperty(value = "维保合同开始日期")
    private Date informStart;

    @ApiModelProperty(value = "维保合同结束日期")
    private Date informEnd;

    @ApiModelProperty(value = "维保负责人姓名")
    private String meMaster;

    @ApiModelProperty(value = "维保负责人身份证号")
    private String meMasterId;

    @ApiModelProperty(value = "紧急救援电话")
    private String emergencycall;

    @ApiModelProperty(value = "维保周期(单位：月)")
    private Integer meCycle;

    @ApiModelProperty(value = "大修周期(单位：月)")
    private Integer overhaulCycle;

    @ApiModelProperty(value = "24小时维保电话")
    private String me24Telephone;
}
