package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.RewardConfig;
import com.yeejoin.precontrol.common.service.IRewardConfigService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
 * 奖励惩罚配置表
 *
 * @author duanwei
 * @date 2021-04-06
 */
@RestController
@Api(tags = "奖励惩罚配置表Api")
@RequestMapping(value = "/reward-config", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class RewardConfigController {

  @Autowired
  IRewardConfigService iRewardConfigService;


    /**
    * 新增奖励惩罚配置表
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增奖励惩罚配置表", notes = "新增奖励惩罚配置表")
    public boolean saveRewardConfig(HttpServletRequest request, @RequestBody RewardConfig rewardConfig){
    return iRewardConfigService.save(rewardConfig);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iRewardConfigService.removeById(id);
    }




    /**
    * 修改奖励惩罚配置表
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改奖励惩罚配置表", notes = "修改奖励惩罚配置表")
    public boolean updateByIdRewardConfig(HttpServletRequest request, @RequestBody RewardConfig rewardConfig){
    return iRewardConfigService.updateById(rewardConfig);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public RewardConfig selectById(HttpServletRequest request, @PathVariable Long id){
      return iRewardConfigService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<RewardConfig> listPage(String pageNum,String pageSize,
    RewardConfig rewardConfig){

    Page<RewardConfig> pageBean;
    QueryWrapper<RewardConfig> rewardConfigQueryWrapper = new QueryWrapper<>();
    Class<? extends RewardConfig> aClass = rewardConfig.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(rewardConfig);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(rewardConfig);
                rewardConfigQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(rewardConfig);
                rewardConfigQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(rewardConfig);
                rewardConfigQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(rewardConfig);
                rewardConfigQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<RewardConfig> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iRewardConfigService.page(pageBean, rewardConfigQueryWrapper);
    return page;
  }
}


