package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerCarCountDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerCompanyCountDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerData;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyResourcesDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferResourceDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.ResourceStatisticsDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransfer;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 力量调派 Mapper 接口
 *
 * @author tb
 * @date 2021-06-17
 */
public interface PowerTransferMapper extends BaseMapper<PowerTransfer> {
    List<PowerTransferCompanyResourcesDto> getPowerTransferList(Long alertCalledId);

    List<PowerTransferCompanyDto> getLastPowerTransferCompany(Long alertCalledId);

    /**
     * 根据警情id获取调派车辆id列表
     *
     * @param alertCalledId
     * @return
     */
    List<String> queryTransferCarIdsByAlertCalledId(@Param("alertCalledId") Long alertCalledId);

    /**
     * 根据起止时间获取力量调派信息
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<PowerTransferDto> getPowerTransferInfo(@Param("beginDate") String beginDate, @Param("endDate") String endDate);

    /**
     * 根据起止时间获取力量调派单位信息
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<PowerTransferCompanyDto> getPowerTransferCompanyInfo(@Param("beginDate") String beginDate,
                                                              @Param("endDate") String endDate);

    /**
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<PowerTransferCompanyResourcesDto> getPowerTransferCompanyResourcesInfo(@Param("beginDate") String beginDate,
                                                       @Param("endDate") String endDate);

    Map<String, Object> getPowerTransferInfoCount(@Param("beginDate") String beginDate,
                                                        @Param("endDate") String endDate);


    Map<String, Integer> getCarNum(@Param("id") Long id);
    Map<String, Integer> getCompanyNum(@Param("id") Long id);

    List<PowerData> getPowerDataList(@Param("id") Long id);

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/23
     * </PRE>
     * 力量调派按单位统计
     */
    List<PowerCompanyCountDto> getPowerCompanyCountDtocount(@Param("id") Long id);

    List<PowerCarCountDto> getPowerCarCountDtocount(@Param("alertCalledId") Long alertCalledId,@Param("companyId") Long companyId);

    /**
     * 根据参数获取警情当前已调派队伍资源列表信息
     *
     * @param alertCalledId 警情id
     * @param page          分页参数
     * @return
     */
    IPage<PowerTransferResourceDto> getPowerTransferTeamResource(Page<PowerTransferResourceDto> page,
                                                                 @Param("alertCalledId") Long alertCalledId);

    /**
     * 根据类型查询力量调派统计
     *
     * @param alertCalledId
     * @param type
     * @return
     */
    List<ResourceStatisticsDto> getPowerTransferTeamResourceCount(Long alertCalledId, String type);

    /**
     * 根据参数获取警情当前已调派车辆资源列表信息
     *
     * @param alertCalledId 警情id
     * @param page          分页参数
     * @return
     */
    IPage<PowerTransferResourceDto> getPowerTransferCarResource(Page<PowerTransferResourceDto> page,
                                                                @Param("alertCalledId") Long alertCalledId);

}
