package com.yeejoin.amos.latentdanger.common.enums;


/**
 * @author DELL
 */

public enum ExecuteTypeEnum {

    /**
     * 未执行
     */
    未执行("未执行", -1),
    通过("通过", 0),
    驳回("驳回", 1);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;


    ExecuteTypeEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static ExecuteTypeEnum getByCode(Integer code) {
        for (ExecuteTypeEnum e : ExecuteTypeEnum.values()) {
            if (code.equals(e.getCode())) {
                return e;
            }
        }
        return null;
    }
}
