package com.yeejoin.amos.latentdanger.common.enums;

/**
 * 业务配置枚举
 *
 * @author DELL
 */
public enum LatentDangerBizTypeEnum {

    /**
     * 防火监督
     */
    防火监督("防火监督", "supervision", "fire_supervision_hazard_management"),
    /**
     * 巡检
     */
    巡检("巡检", "patrol", "");

    /**
     * 业务名称
     */
    String name;

    /**
     * 业务code
     */
    String code;

    /**
     * 业务对应工作流定义key
     */
    String workflowDefKey;

    LatentDangerBizTypeEnum(String name, String code, String workflowDefKey) {
        this.name = name;
        this.code = code;
        this.workflowDefKey = workflowDefKey;
    }

    public static LatentDangerBizTypeEnum getByCode(String code) {
        for (LatentDangerBizTypeEnum l : LatentDangerBizTypeEnum.values()) {
            if (l.getCode().equals(code)) {
                return l;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
