package com.yeejoin.amos.latentdanger.dao.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author keyong
 * @title: LatentDanger
 * <pre>
 * @description: 隐患表
 * </pre>
 * @date 2021/1/26 14:03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_latent_danger")
@ApiModel(value="LatentDanger", description="隐患信息")
public class LatentDanger extends BasicEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 业务唯一标识
     */
    @Column(name = "business_key")
    private String businessKey;

    /**
     * 公司组织机构
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 隐患名称
     */
    @Column(name = "danger_name")
    private String dangerName;

    @Column(name = "instance_id")
    private String instanceId;

    @Column(name = "current_flow_record_id")
    private Long currentFlowRecordId;

    /**
     * 隐患等级（1：一般隐患；2：重大隐患；0：安全问题）
     */
    @Column(name = "danger_level")
    private String dangerLevel;

    /**
     * 隐患等级名称
     */
    @Column(name = "danger_level_name")
    private String dangerLevelName;

    /**
     * 隐患地点
     */
    @Column(name = "danger_position")
    private String dangerPosition;

    /**
     * 隐患类型（1：普通隐患；2：巡检隐患）
     */
    @Column(name = "danger_type")
    private String dangerType;

    /**
     * 隐患类型名称
     */
    @Column(name = "danger_type_name")
    private String dangerTypeName;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 整改类型（1：常规整改；2：安措计划；3：延期整改）
     */
    @Column(name = "reform_type")
    private String reformType;

    /**
     * 整改类型名称
     */
    @Column(name = "reform_type_name")
    private String reformTypeName;

    /**
     * 限制时间
     */
    @Column(name = "reform_limit_date")
    private Date reformLimitDate;

    @Column(name = "overtime_state")
    private Integer overtimeState;

    @Column(name = "reform_json")
    private String reformJson;

    /**
     * 隐患状态（1：待评审；2：待治理；3：安措计划中；4：逾期未治理；5：待验证；6：治理完毕；7：已撤销）
     */
    @Column(name = "danger_state")
    private String dangerState;

    /**
     * 隐患状态名称
     */
    @Column(name = "danger_state_name")
    private String dangerStateName;

    /**
     * 发现人
     */
    @Column(name = "discoverer_user_id")
    private String discovererUserId;

    @Column(name = "discoverer_department_id")
    private String discovererDepartmentId;

    @Column(name = "photo_urls")
    private String photoUrls;

    /**
     * 是否删除（0：否；1：是）
     */
    @Column(name = "deleted")
    private Boolean deleted;

    /**
     * 记录修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 延期治理时间
     */
    @Column(name = "delay_limit_date")
    private Date delayLimitDate;

    /**
     * 问题描述
     */
    @Column(name = "problem_description")
    private String problemDescription;

    /**
     * 原因分析
     */
    @Column(name = "reason_analysis")
    private String reasonAnalysis;

    /**
     * 举一反三
     */
    @Column(name = "infer_other_things")
    private String inferOtherThings;

    /**
     * 检查记录创建的隐患检查项对应id
     */
    @Column(name = "biz_id")
    private Long bizId;

    /**
     * 建筑id
     */
    @Column(name = "structure_id")
    private Long structureId;

    /**
     * 建筑名称
     */
    @Column(name = "structure_name")
    private String structureName;

    @Column(name = "instance_key")
    private String instanceKey;

    /**
     * 业务类型（不同业务创建的隐患以此区分:巡检隐患、防火监督隐患、其他隐患。。。）
     */
    @Column(name = "biz_type")
    private String bizType;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 业务信息
     */
    @Column(name = "biz_info")
    private String bizInfo;
}
