package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.common.api.entity.SpecialPositionStaff;
import com.yeejoin.amos.boot.module.common.api.mapper.SpecialPositionStaffMapper;
import com.yeejoin.amos.boot.module.common.api.service.ISpecialPositionStaffService;
import com.yeejoin.amos.boot.module.common.api.dto.SpecialPositionStaffDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.HashMap;
import java.util.List;

/**
 * 特岗人员服务实现类
 *
 * @author system_generator
 * @date 2021-07-23
 */
@Service
public class SpecialPositionStaffServiceImpl extends BaseService<SpecialPositionStaffDto, SpecialPositionStaff,
        SpecialPositionStaffMapper> implements ISpecialPositionStaffService {

    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;

    /**
     * 分页查询
     */
    public Page<SpecialPositionStaffDto> queryForSpecialPositionStaffPage(Page<SpecialPositionStaffDto> page,
                                                                          @Condition(Operator.eq) Long companyId,
                                                                          @Condition(Operator.eq) Boolean isDelete,
                                                                          @Condition(Operator.eq) String positionNameCode) {
        return this.queryForPage(page, null, false, companyId, isDelete, positionNameCode);
    }

    /**
     * 列表查询 示例
     */
    public List<SpecialPositionStaffDto> queryForSpecialPositionStaffList() {
        return this.queryForList("", false);
    }

    /**
     * 批量删除
     *
     * @param sequenceNbrList
     * @return
     */
    public Boolean batchDelete(List<Long> sequenceNbrList) {
        List<SpecialPositionStaff> positionStaffList =
                list(new LambdaQueryWrapper<SpecialPositionStaff>().in(SpecialPositionStaff::getSequenceNbr,
                        sequenceNbrList));
        positionStaffList.forEach(item -> item.setIsDelete(true));
        boolean update = updateBatchById(positionStaffList);
        return update;
    }

    public HashMap<Object, Object> getSpecialPositionStaffList(Long companyId) throws Exception {
        // 查询所有岗位类型
        List<MenuFrom> menuList = dataDictionaryService.getGWMCDataDictionary("GWMC");
        // 查询已有数据的岗位类型
        List<Long> positionStaffCodeList = this.baseMapper.getPositionStaffCodeList(false,companyId);
        // 排除已有数据的，返回
        for (int i = 0; i < menuList.size(); i++) {
            if (positionStaffCodeList.contains(Long.valueOf(menuList.get(i).getKey()))) {
                menuList.remove(i);
                i--;
            }
        }
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        objectObjectHashMap.put("GWMC", menuList);
        return objectObjectHashMap;
    }
}