package com.yeejoin.amos.latentdanger.schedule;
import com.yeejoin.amos.latentdanger.business.service.intfc.ILatentDangerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

/**
 * 隐患定时任务
 * @author DELL
 */
@Configuration("latentDangerScheduled")
@EnableScheduling
public class LatentDangerScheduled {

    @Autowired
    private ILatentDangerService iLatentDangerService;

    /**
     * 每1分钟执行一次：查询逾期的隐患，修改状态
     */
//    @Scheduled(cron = "0 0/1 * * * ?")
    public void updateDangerStateOfOvertime() {
        iLatentDangerService.updateDangerStateOfOvertime();
    }
}