package com.yeejoin.amos.supervision.business.service.intfc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.supervision.business.dto.HiddenDangerExportDataDto;
import com.yeejoin.amos.supervision.business.dto.HiddenDangerImportDto;
import com.yeejoin.amos.supervision.core.common.dto.DangerDto;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author DELL
 */
public interface IHiddenDangerService {
    /**
     * 重新指定的隐患数据
     *
     * @param planId  计划id
     * @param pointId 点id
     * @param level   隐患级别
     * @param status  状态
     * @return List<HiddenDangerExportDto>
     */
    List<HiddenDangerExportDataDto> listAll(String planId, Long pointId, String level, String status);


    /**
     * 隐患详情
     *
     * @param dangerId 隐患id
     * @return DangerDto
     */
    DangerDto getOne(Long dangerId);

    /**
     * 隐患更新
     *
     * @param dangerId  隐患id
     * @param dangerDto 隐患对象
     * @return DangerDto
     */
    DangerDto updateDanger(Long dangerId, DangerDto dangerDto);

    /**
     * 分页查询
     *
     * @param page    分页信息
     * @param planId  计划id
     * @param pointId 点id
     * @param level   隐患级别
     * @param status  状态
     * @return
     */
    IPage<DangerDto> pageList(Page page, String planId, Long pointId, String level, String status);

    /**
     * 导入
     * @param selectedOrgInfo 用户信息
     * @param planId  计划id
     * @param list    数据
     */
    void importDanger(ReginParams selectedOrgInfo, Long planId, List<HiddenDangerImportDto> list);

    /**
     * 下载模板
     * @param response 输出
     */
    void templateExport(HttpServletResponse response);

    /**
     * 隐患数据导出
     * @param dtoList数据
     * @param response 响应
     */
    /**
     * 隐患数据导出
     * @param planId 计划id
     * @param pointId 点id
     * @param level   隐患级别
     * @param status  状态
     * @param response 响应
     */
    void exportDangerData(String planId, Long pointId, String level, String status, HttpServletResponse response);

    /**
     * 批量删除
     * @param ids 隐患ids
     * @return Boolean
     */
    Boolean deleteBatch(List<Long> ids);
}
