package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.adapter;

import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.dto.DocGenerationRequest;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class DefaultDocGenerateAdapter implements DocGenerateAdapter {
    private final JyjcInspectionApplicationMapper repository;

    /**
     * 将DB实体转换为DTO
     */
    @Override
    public DocGenerationRequest prepareRequest(String appSeq) {
        JyjcInspectionApplication entity = repository.selectById(appSeq);
        return DocGenerationRequest.builder()
                .equipList(entity.getEquipClassify())
                .equCategory(entity.getEquCategory())
                .equDefine(entity.getEquDefine())
                .appSeq(appSeq)
                .build();
    }
}
