package com.yeejoin.amos.boot.module.tcm.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 微信公众号任务列表dto类
 * kongfm
 */
@Data
@ApiModel(value="WechatMyTaskListDto", description="微信公众号任务列表dto类")
public class WechatMyTaskListDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "任务类型")
    private String taskType;

    @ApiModelProperty(value = "是否结案")
    private Boolean taskStatus;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "派遣时间")
    private Date dispatchTime;

    @ApiModelProperty(value = "上报时间")
    private Date reportTime;

    @ApiModelProperty(value = "完成时间")
    private Date finishTime;

}
