package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ZLDPStatisticsServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.vo.EquCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;


/**
 * 大屏控制层
 *
 * @author maxy
 * @date 2024-07-09
 */
@RestController
@Api(tags = "大屏-总览统计API")
@RequestMapping(value = "/dp/zl")
public class ZLDPStatisticsController {

    private ZLDPStatisticsServiceImpl statisticsService;

    public ZLDPStatisticsController(ZLDPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/companyInfo")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-左屏-企业统计", notes = "大屏-总览-左屏-企业统计")
    public ResponseModel<List<Map<String, Object>>> companyInfo(@RequestBody DPFilterParamDto screenDto) {
        return ResponseHelper.buildResponse(statisticsService.companyInfo(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/testOrg")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-左屏-检测机构统计", notes = "大屏-总览-左屏-检测机构统计")
    public ResponseModel<List<Map<String, Object>>> testOrg(@RequestBody DPFilterParamDto screenDto) {
        return ResponseHelper.buildResponse(statisticsService.testOrg(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/userCount")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-左屏-人员统计", notes = "大屏-总览-左屏-人员统计")
    public ResponseModel<Map<String, Object>> userCount(@RequestBody DPFilterParamDto screenDto) {
        return ResponseHelper.buildResponse(statisticsService.userCount(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/userCountNew")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-左屏-人员统计新", notes = "大屏-总览-左屏-人员统计")
    public ResponseModel<Map<String, Object>> userCountNew(@RequestBody DPFilterParamDto screenDto) {
        return ResponseHelper.buildResponse(statisticsService.userCountNew(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/supervisorCount")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-左屏-行业主管部门统计", notes = "大屏-总览-左屏-行业主管部门统计")
    public ResponseModel<Map<String, Object>> supervisorCount(@RequestBody DPFilterParamDto screenDto) {
        return ResponseHelper.buildResponse(statisticsService.supervisorCount(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/equipmentInformCount")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-左屏-设备使用场所统计", notes = "大屏-总览-左屏-设备使用场所统计")
    public ResponseModel<List<Map<String, Object>>> equipmentInformCount(@RequestBody DPFilterParamDto screenDto) {
        return ResponseHelper.buildResponse(statisticsService.equipmentInformCount(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping (value = "/region/info")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-安全监管 (近7天)", notes = "安全监管 (近7天)")
    public ResponseModel<JSONArray> statisticsRegionInfo(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.statisticInfoByRegionAndDate(dpFilterParamDto));
    }

    /**
     * 大屏-总览-左屏-设备纳管率
     * @return Map
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getEquipManagementRateStatistics")
    @ApiOperation(httpMethod = "POST", value = "大屏-总览-左屏-设备纳管率", notes = "大屏-总览-左屏-设备纳管率")
    public ResponseModel<Map<String, Object>> getEquipManagementRateStatistics(@RequestBody DPFilterParamForDetailDto paramDto){
        return ResponseHelper.buildResponse(statisticsService.getEquipManagementRateStatistics(paramDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/viewJgAll")
    @ApiOperation(httpMethod = "GET", value = "viewJgAll", notes = "viewJgAll")
    public ResponseModel<Page<JSONObject>> viewJgAll(@RequestParam Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        return ResponseHelper.buildResponse(statisticsService.queryByKeys(jsonObject));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/viewEquipPage")
    @ApiOperation(httpMethod = "POST", value = "查询设备管理列表", notes = "查询设备管理列表")
    public ResponseModel<Page<JSONObject>> viewEquipPage(@RequestBody DPFilterParamForDetailDto paramDto,
                                                         @RequestParam("size") Integer size,
                                                         @RequestParam("current") Integer current) {
        paramDto.setCurrent(current);
        paramDto.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.viewEquipPage(paramDto));
    }

    /**
     * 根据设备种类code获取设备类别下拉
     *
     * @param paramDto 设备种类code
     * @return 设备类别列表
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getEquCategoryList")
    @ApiOperation(httpMethod = "POST", value = "根据设备种类code获取设备类别下拉", notes = "根据设备种类code获取设备类别下拉")
    public ResponseModel<List<EquCategoryVo>> getEquCategoryTree(@RequestBody DPFilterParamForDetailDto paramDto){
        return ResponseHelper.buildResponse(statisticsService.getEquCategoryList(paramDto.getTreeValue()));
    }

    /**
     * 设备八大类列表树
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "设备八大类列表树", notes = "设备八大类列表树")
    @GetMapping(value = "/equipTree")
    public ResponseModel<Object> equipTree(@RequestParam(value = "type", required = false) String type) {
        return ResponseHelper.buildResponse(statisticsService.equipTree(type));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/personPage")
    @ApiOperation(httpMethod = "POST", value = "查询人员列表", notes = "查询人员列表")
    public ResponseModel<Page<Map<String, Object>>> personPage(@RequestBody DPFilterParamDto paramDto,
                                                               @RequestParam("size") Integer size,
                                                               @RequestParam("current") Integer current) {
        Page page = new Page<>(current, size);
        return ResponseHelper.buildResponse(statisticsService.getPersonPage(paramDto, page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/personType")
    @ApiOperation(httpMethod = "GET", value = "查询人员类型", notes = "查询人员类型")
    public ResponseModel<List<Map<String, String>>> personType(@RequestParam(value = "companyType",required = false) String companyType) {
        return ResponseHelper.buildResponse(statisticsService.getPersonType(companyType));
    }
}
