package com.yeejoin.amos.boot.module.ys.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 应急联动单位管理
 *
 * @author system_generator
 * @date 2024-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="YsEmergencyUnitDto", description="应急联动单位管理")
public class YsEmergencyUnitDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "关联消防队")
    private Integer teamId;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "经纬度")
    @TableField("longitudeLatitude")
    private String longitudeLatitude;

    @ApiModelProperty(value = "应急服务内容")
    private String emergencyService;

    @ApiModelProperty(value = "单位传真")
    private String fax;

    @ApiModelProperty(value = "保障能力")
    private String guaranteeCapability;

    @ApiModelProperty(value = "保障类别")
    private String guaranteeType;

    @ApiModelProperty(value = "联系人")
    private String linkman;

    @ApiModelProperty(value = "部门代码")
    private String orgCode;

    @ApiModelProperty(value = "单位概述")
    private String overview;

    @ApiModelProperty(value = "负责人")
    private String person;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "单位图片")
    private String picture;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "单位编号")
    private String unitNum;

    @ApiModelProperty(value = "单位类型")
    private String unitType;

    @ApiModelProperty(value = "行政区划编号")
    private String xzqhbh;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

}
