package com.yeejoin.amos.boot.module.ys.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ys.api.dto.YsEmergencyExpertsDto;
import com.yeejoin.amos.boot.module.ys.api.service.IYsEmergencyExpertsService;
import com.yeejoin.amos.boot.module.ys.biz.service.impl.YsEmergencyExpertsServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 *
 * @author system_generator
 * @date 2024-09-24
 */
@RestController
@Api(tags = "应急专家库")
@RequestMapping(value = "/ys-emergency-experts")
public class YsEmergencyExpertsController extends BaseController {

	@Autowired
	private IYsEmergencyExpertsService iYsEmergencyExpertsService;

    @Autowired
    YsEmergencyExpertsServiceImpl ysEmergencyExpertsServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveOrUpdate")
	@ApiOperation(httpMethod = "POST", value = "新增or更新", notes = "新增or更新")
	public ResponseModel<Boolean> saveOrUpdate(@RequestBody Map<String, Object> model) {
		AgencyUserModel userModel = getSelectedOrgInfo().getUserModel();
		return ResponseHelper.buildResponse(iYsEmergencyExpertsService.saveOrUpdate(model,userModel));
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<YsEmergencyExpertsDto> updateBySequenceNbrYsEmergencyExperts(@RequestBody YsEmergencyExpertsDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(ysEmergencyExpertsServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/deleteById")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") String sequenceNbr){
        return ResponseHelper.buildResponse(iYsEmergencyExpertsService.deleteById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/detail")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<YsEmergencyExpertsDto> selectOne(@RequestParam String sequenceNbr) {
	    return ResponseHelper.buildResponse(iYsEmergencyExpertsService.queryBySequenceNbr(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/page")
	@ApiOperation(httpMethod = "POST",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<Map<String, Object>>> queryForPage(YsEmergencyExpertsDto dto,
																 @RequestParam(value = "current") int current,
																 @RequestParam(value = "size") int size) {
		Page<Map<String, Object>> page = new Page<>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(ysEmergencyExpertsServiceImpl.queryForYsEmergencyExpertsPage(dto,page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<YsEmergencyExpertsDto>> selectForList() {
	    return ResponseHelper.buildResponse(ysEmergencyExpertsServiceImpl.queryForYsEmergencyExpertsList());
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/import")
	@ApiOperation(httpMethod = "POST", value = "专家库列表数据导入", notes = "专家库列表数据导入")
	public ResponseModel<Object> expertDataImport(@RequestBody MultipartFile file) {
		// 校验文件是否为空
		if (file.isEmpty()) {
			return ResponseHelper.buildResponse("文件不能为空");
		}
		// 校验文件类型为 Excel
		String contentType = file.getContentType();
		String fileExtension = FilenameUtils.getExtension(file.getOriginalFilename());
		// 校验 Excel 文件的 MIME type 和扩展名
		if (!("application/vnd.ms-excel".equals(contentType) ||
				"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType)) ||
				!("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension))) {
			return ResponseHelper.buildResponse("文件类型必须是 Excel 文件");
		}
		return ysEmergencyExpertsServiceImpl.expertDataImport(file);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/export")
	@ApiOperation(httpMethod = "GET", value = "专家库列表数据导出", notes = "专家库列表数据导出")
	public void expertDataExport(HttpServletResponse response, String ids) {
		Assert.hasText(ids,"未选择导出数据");
		ysEmergencyExpertsServiceImpl.export(response, Arrays.asList(ids.split(",")));
	}

}
