package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


@AllArgsConstructor
@Getter
public enum EquipmentTypeEnum {

    /**
     * 设备类型对应表单key
     */
    DT("电梯", "3000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "1636347684057018369", "1636282043618848769", "1637431088563384322", "idx_biz_jg_tech_params_elevator"),
    QZJ("起重机械", "4000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "", "1636282043618848769", "1635115308320583681", "idx_biz_jg_tech_params_lifting"),
    CS("厂车", "5000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "", "1636282043618848769", "1631125079347720193", "idx_biz_jg_tech_params_vehicle"),
    GL("锅炉", "1000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "", "1636282043618848769", "1631125178945662977", "idx_biz_jg_tech_params_boiler"),
    YL_GD("压力管道", "8000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "", "1636282043618848769", "1631125206695178241", "idx_biz_jg_tech_params_pipeline"),
    YL_RQ("压力容器", "2000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "", "1636282043618848769", "1631125198260432897", "idx_biz_jg_tech_params_vessel"),
    YL_SS("游乐设施", "6000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "", "1636282043618848769", "1631125167914643457", "idx_biz_jg_tech_params_rides"),
    SD("索道", "9000", "1627903393253056514", "1627897116087050241", "1627903532906602497", "1636347672031948801", "", "1636282043618848769", "1631125158229995521", "idx_biz_jg_tech_params_ropeway");


    /**
     * 名称
     */
    private final String name;

    /**
     * 类型编码
     */
    private final String code;

    /**
     * 使用信息
     */
    private final String useInfo;

    /**
     * 设计信息
     */
    private final String desInfo;

    /**
     * 监督管理信息
     */
    private final String supInfo;

    /**
     * 施工信息
     */
    private final String comInfo;

    /**
     * 维保信息
     */
    private final String mainInfo;

    /**
     * 检验检测信息
     */
    private final String insInfo;

    /**
     * 注册信息
     */
    private final String jriInfo;

    /**
     * 注册信息参数对应表
     */
    private final String tableName;


    public static EquipmentTypeEnum getEnumByCode(String code) {
        for (EquipmentTypeEnum value : EquipmentTypeEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
