package com.yeejoin.amos.latentdanger.business.feign;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.boot.module.common.api.dto.CompanyPerson;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 机场服务feign
 *
 * @author Dell
 */
@FeignClient(name = "${jcs.fegin.name}", path = "jcs", configuration = {MultipartSupportConfig.class})
public interface JcsFeignClient {
    /**
     * 根据机场人员id获取amos平台人员id
     *
     * @param orgUserId 机场单位人员id
     * @return AgencyUserModel 平台人员信息
     **/
    @RequestMapping(value = "/org-usr/amos/{orgUserId}", method = RequestMethod.GET)
    ResponseModel<AgencyUserModel> getAmosIdByUserId(@PathVariable String orgUserId);

    /**
     * 查询用户单位信息
     *
     * @return ResponseModel<ReginParams.PersonIdentity>
     */
    @GetMapping(value = "/org-usr/getLoginUserDetails")
    FeignClientResult getJcsUser();

    /**
     * 根据id获取单位人员列表
     */
    @GetMapping(value = "/org-usr/company/{ids}/person")
    FeignClientResult<List<CompanyPerson>> selectCompanyPerson(@PathVariable List<Long> ids);
}
