package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 电梯
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialElevatorModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备全省唯一编号
     */
    private String sequenceCode;
    /**
     * 运行速度（m/s）
     */
    private String runningSpeed;
    /**
     * 额定载荷（kg）
     */
    private String ratedLoad;
    /**
     * 电梯层站（层）
     */
    private String elevatorLanding;
    /**
     * 提升高度（m）
     */
    private String liftingHeight;
    /**
     * 曳引机型号
     */
    private String tractionMachineModel;
    /**
     * 曳引机出厂编号
     */
    private String tractionMachineFactoryNum;
    /**
     * 电动机型号
     */
    private String motorModel;
    /**
     * 电动机出厂编号
     */
    private String motorFactoryNum;
    /**
     * 控制屏型号
     */
    private String controlPanelModel;
    /**
     * 控制屏出厂编号
     */
    private String controlPanelFactoryNum;
    /**
     * 限速器型号
     */
    private String speedGovernorModel;
    /**
     * 限速器出厂编号
     */
    private String speedGovernorFactoryNum;
    /**
     * 控制方式
     */
    private String controlMode;
    /**
     * 使用区域长度(m)
     */
    private String useAreaLength;
    /**
     * 输送能力(人/h)
     */
    private String conveyingCapacity;
    /**
     * 扶梯倾斜角（°）
     */
    private String escalatorInclinationAngle;
    /**
     * 梯级宽度（m）
     */
    private String stepWidth;

}
