package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 单位变更登记
 *
 * @author system_generator
 * @date 2024-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_change_vehicle_registration_unit")
public class JgChangeVehicleRegistrationUnit extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 变更类型（0区内，1区外）
     */
	@TableField("change_type")
    private String changeType;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 申请日期
     */
	@TableField("apply_date")
    private Date applyDate;

    /**
     * 登记机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 登记机构代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 登记机构公司代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 终审通过时间
     */
	@TableField("audit_pass_date")
    private Date auditPassDate;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 原使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 原使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 新使用单位统一信用代码
     */
	@TableField("new_use_unit_credit_code")
    private String newUseUnitCreditCode;

    /**
     * 新使用单位名称
     */
	@TableField("new_use_unit_name")
    private String newUseUnitName;

    /**
     * 变更证明（买卖合同或其他变更使用单位证明）
     */
	@TableField("change_certificate")
    private String changeCertificate;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 流程执行顺序标识
     */
	@TableField("execute_sequence")
    private String executeSequence;

    /**
     * 下一执行节点ids
     */
	@TableField("next_executor_ids")
    private String nextExecutorIds;

    /**
     * 任务发起人id
     */
	@TableField("promoter")
    private String promoter;

    /**
     * 流程已执行记录角色id
     */
	@TableField("instance_status")
    private String instanceStatus;

    /**
     * 办理状态
     */
	@TableField("status")
    private String status;

    /**
     * 设备使用登记注册编号
     */
	@TableField("use_regist_code")
    private String useRegistCode;

    /**
     * 工作流下一节点任务id
     */
	@TableField("next_task_id")
    private String nextTaskId;

    /**
     * 下一节点执行人userIds
     */
	@TableField("next_execute_user_ids")
    private String nextExecuteUserIds;

    /**
     * 其他附件
     */
	@TableField("other_accessories")
    private String otherAccessories;

    /**
     * 接收单位org_code本来应该为receive_org_code但该字段被占用故同一此字段
     */
	@TableField("receive_company_org_code")
    private String receiveCompanyOrgCode;

    /**
     * 经办人
     */
	@TableField("agent")
    private String agent;

    /**
     * 经办人联系电话
     */
	@TableField("agent_phone")
    private String agentPhone;

    /**
     * 行驶证正面附件
     */
	@TableField("drive_license_front")
    private String driveLicenseFront;

    /**
     * 行驶证背面附件
     */
	@TableField("drive_license_back")
    private String driveLicenseBack;

    /**
     * 机动车登记证书附件
     */
	@TableField("vehicle_registration_certificate")
    private String vehicleRegistrationCertificate;

    /**
     * 属地监管部门code
     */
	@TableField("org_branch_code")
    private String orgBranchCode;

    /**
     * 属地监管部门name
     */
	@TableField("org_branch_name")
    private String orgBranchName;

    /**
     * 车辆属地
     */
	@TableField("vehicle_apanage")
    private String vehicleApanage;

    /**
     * 车牌号
     */
	@TableField("car_number")
    private String carNumber;

    /**
     *  新车牌号
     */
    @TableField("new_car_number")
    private String newCarNumber;

    /**
     * 转办
     */
	@TableField("transfer_to_user_ids")
    private String transferToUserIds;

    @TableField(exist = false)
    private String address;
}
