package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseRelationEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户资质信息表
 *
 * @author system_generator
 * @date 2024-08-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_user_permission")
public class TzsUserPermission extends BaseRelationEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主表主键
     */
	@TableField("user_seq")
    private Long userSeq;

    /**
     * 检验检测专用-级别
     */
	@TableField("permission_level")
    private String permissionLevel;

    /**
     * 检验检测专用-资质项目
     */
	@TableField("permission_item")
    private String permissionItem;

    /**
     * 人员类型，前端用来分组展示使用(permissionData{post})
     */
	@TableField("permission_post")
    private String permissionPost;

    /**
     * 证书编号
     */
	@TableField("cert_no")
    private String certNo;

    /**
     * 有效期至
     */
	@TableField("expiry_date")
    private Date expiryDate;

    /**
     * 发证机关
     */
	@TableField("approved_organ")
    private String approvedOrgan;

    /**
     * 发证日期
     */
	@TableField("issue_date")
    private Date issueDate;

    /**
     * 证书附件
     */
	@TableField("cert_attachment")
    private String certAttachment;

    /**
     * 证书类型
     */
	@TableField("cert_type")
    private String certType;

    /**
     * 作业项目
     */
	@TableField("job_item")
    private String jobItem;

    /**
     * 项目代号,多个用逗号分割
     */
    @TableField("item_code")
    private String itemCode;

    /**
     * 其他作业项目
     */
	@TableField("other_item")
    private String otherItem;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

}
