package com.yeejoin.amos.boot.module.jg.biz.handler;

import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.event.handler.SafetyProblemEventHandler;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgOtherInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SafetyProblemTracingServiceImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SafetyProblemEventHandlerFactory {

    private static ApplicationContext context;

    public static void setApplicationContext(ApplicationContext applicationContext) {
        context = applicationContext;
    }
    public static SafetyProblemEventHandler createProblemHandler(String topic) {
        SafetyProblemTracingServiceImpl safetyProblemTracingService = context.getBean(SafetyProblemTracingServiceImpl.class);
        IdxBizJgOtherInfoServiceImpl idxBizJgOtherInfoService = context.getBean(IdxBizJgOtherInfoServiceImpl.class);
        ESEquipmentCategory esEquipmentCategory = context.getBean(ESEquipmentCategory.class);
        if (topic.startsWith(SafetyProblemTypeEnum.WBCQ.getTopic())) {
            return new WBCQEventHandler(safetyProblemTracingService);
        } else if (topic.startsWith(SafetyProblemTypeEnum.WBBA.getTopic())) {
            return new WBBAEventHandler(safetyProblemTracingService, idxBizJgOtherInfoService, esEquipmentCategory);
        } else if (topic.startsWith(SafetyProblemTypeEnum.JYCQ.getTopic())) {
            return new JYCQEventHandler(safetyProblemTracingService);
        } else if (topic.startsWith(SafetyProblemTypeEnum.JYBJ.getTopic())) {
            return new JYBJEventHandler(safetyProblemTracingService, idxBizJgOtherInfoService, esEquipmentCategory);
        } else if (topic.startsWith(SafetyProblemTypeEnum.XKCQ.getTopic())) {
            return new XKCQEventHandler(safetyProblemTracingService);
        }else if (topic.startsWith(SafetyProblemTypeEnum.ZZCQ.getTopic())) {
            return new ZZCQEventHandler(safetyProblemTracingService);
        } else {
            // 其他策略类的创建
            throw new IllegalArgumentException("Unsupported topic: " + topic);
        }
    }
}

