package com.yeejoin.amos.boot.module.tcm.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.entity.TzsUserPermission;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class HistoryDataDealServiceImpl {

    private TzsUserInfoServiceImpl userInfoService;

    private TzsUserPermissionServiceImpl userPermissionService;

    public HistoryDataDealServiceImpl(TzsUserInfoServiceImpl userInfoService, TzsUserPermissionServiceImpl userPermissionService) {
        this.userInfoService = userInfoService;
        this.userPermissionService = userPermissionService;
    }

    @Transactional(rollbackFor = Exception.class)
    public int userPermissionUpdate() {
        log.info("刷存量人员资质开始");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List<TzsUserInfo> usersOfHavingPermission = userInfoService.list(new LambdaQueryWrapper<TzsUserInfo>().isNotNull(TzsUserInfo::getPermissionData));
        List<TzsUserPermission> allWaitFlushData = new ArrayList<>();
        usersOfHavingPermission.forEach(u -> {
            JSON.parseObject(u.getPermissionData()).forEach((k, v) -> {
                List<TzsUserPermission> userPermissions = JSONArray.parseArray(v.toString(), TzsUserPermission.class);
                userPermissions.forEach(p -> {
                    p.setUserSeq(u.getSequenceNbr());
                    p.setPermissionPost(k);
                    p.setRecDate(new Date());
                    p.setRecUserName(u.getRecUserName());
                    p.setRecUserId(u.getRecUserId());
                    p.setRemark("存量数据刷入");
                });
                allWaitFlushData.addAll(userPermissions);
            });
        });
        if (allWaitFlushData.size() > 0) {
            userPermissionService.saveBatch(allWaitFlushData);
        }
        stopWatch.stop();
        log.info("刷存量人员资质结束,有资质的人员数量:{}, 插入的资质条数：{}，耗时：{}秒", usersOfHavingPermission.size(), allWaitFlushData.size(), stopWatch.getTotalTimeSeconds());
        return allWaitFlushData.size();
    }

    @Transactional(rollbackFor = Exception.class)
    public Integer userPersonTypeUpdate() {
        log.info("刷存量人员类型开始");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LambdaQueryWrapper<TzsUserInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(BaseEntity::getSequenceNbr,TzsUserInfo::getPost,TzsUserInfo::getPostName);
        wrapper.isNotNull(TzsUserInfo::getPost);
        List<TzsUserInfo> users = userInfoService.list(wrapper);
        users.parallelStream().forEach(u->{
            LambdaUpdateWrapper<TzsUserInfo> updateWrapper = new LambdaUpdateWrapper<>();
            // 维保人员人员类型去掉，数据归并到作业人员-枚举处理
            updateWrapper.set(TzsUserInfo::getNewPost, u.getPost().replace("6618","6552"));
            // 由于目前系统作业人员为新增的资质，还没维护资质信息，故与测试沟通去掉post里面的6618维保人员，人员维护后程序会把6618重新冗余到post字段
            updateWrapper.set(TzsUserInfo::getPost, u.getPost().replace("6618",""));
            // 维保人员人员类型去掉，数据归并到作业人员-名称处理保持与new_post一致
            if (u.getPostName() != null) {
                updateWrapper.set(TzsUserInfo::getPostName, u.getPostName().replace("维保人员", "作业人员"));
            }
            updateWrapper.eq(BaseEntity::getSequenceNbr, u.getSequenceNbr());
            userInfoService.update(updateWrapper);
        });

        stopWatch.stop();
        log.info("刷存量人员类型结束，人员数量:{}，耗时：{}秒", users.size(), stopWatch.getTotalTimeSeconds());
        return users.size();
    }
}
