package com.yeejoin.amos.boot.module.jyjc.api.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.module.jyjc.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 业务开通申请表
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@ApiModel(value = "JyjcInspectionResultDataModel", description = "检验检测结果数据接收")
public class JyjcInspectionResultDataModel {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "报检单号")
    private String applicationNo;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "检验结果状态（已出2、未出1）")
    private String resultStatus;

    @ApiModelProperty(value = "核准证号/许可证号")
    private String licenseNumber;

    @ApiModelProperty(value = "检验报告编号")
    private String resultNo;

    @ApiModelProperty(value = "内部人员代码")
    private String innerPersonCode;

    @ApiModelProperty(value = "检验结论")
    private String inspectionConclusion;

    @ApiModelProperty(value = "检验日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date inspectionDate;

    @ApiModelProperty(value = "下次检验日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date nextInspectionDate;

    @ApiModelProperty(value = "检验开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date inspectionStartDate;

    @ApiModelProperty(value = "检验结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date inspectionEndDate;

    @ApiModelProperty(value = "检验结果汇总")
    private String inspectionResultSummary;

    @ApiModelProperty(value = "不符合项")
    private JSONArray nonConformance;

    @ApiModelProperty(value = "附件")
    private List<AttachmentData> attachments;

    @ApiModelProperty(value = "检验结果技术参数")
    private JSONObject techParams;

    /**
     * 校验检验系统唯一流水号,排查问题，跟踪问题使用
     */
    private String traceId;

    /**
     * 设备唯一标识，record--首检时需要，此时设备无监管码及设备代码
     */
    private String equipId;

}
