package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-电梯
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidEquipTechParamElevatorDto", description="安全追溯-电梯Dto")
public class MidEquipTechParamElevatorModel extends AbstractBaseModel {
    private static final long serialVersionUID = 1L;


            @ApiModelProperty(value = "$column.comments")
        private String supervisoryCode;

            @ApiModelProperty(value = "$column.comments")
        private String instanceId;
            @ApiModelProperty(value = "$column.comments")
        private String status;
            @ApiModelProperty(value = "额定速度（上行）")
        private BigDecimal ratedSpeedUp;
            @ApiModelProperty(value = "额定速度（下行）")
        private BigDecimal ratedSpeedDown;
            @ApiModelProperty(value = "额定载重量")
        private BigDecimal ratedLoadCapacity;
            @ApiModelProperty(value = "轿厢尺寸")
        private BigDecimal carSize;
            @ApiModelProperty(value = "提升高度")
        private BigDecimal liftingHeight;
            @ApiModelProperty(value = "层")
        private Integer storey;
            @ApiModelProperty(value = "站")
        private Integer stand;
            @ApiModelProperty(value = "门数")
        private Integer numberDoors;
            @ApiModelProperty(value = "控制方式")
        private String controlMode;
            @ApiModelProperty(value = "油缸数量")
        private Integer numberCylinders;
            @ApiModelProperty(value = "顶升型式")
        private String jackingType;
            @ApiModelProperty(value = "额定压力")
        private BigDecimal ratedPressure;
            @ApiModelProperty(value = "防爆型式")
        private String explosionproofType;
            @ApiModelProperty(value = "防爆等级")
        private String explosionproofGrade;
            @ApiModelProperty(value = "燃爆物质")
        private String explosiveSubstance;
            @ApiModelProperty(value = "整机防爆标志")
        private String explosionproofSignComplete;
            @ApiModelProperty(value = "驱动主机额定功率")
        private BigDecimal qdzjRatedPower;
            @ApiModelProperty(value = "驱动主机额定转速")
        private BigDecimal qdzjRatedSpeed;
            @ApiModelProperty(value = "驱动主机减速比")
        private BigDecimal qdzjReductionRatio;
            @ApiModelProperty(value = "液压泵站满载工作压力")
        private BigDecimal yabzFullloadPressure;
            @ApiModelProperty(value = "悬挂系统悬挂介质种类")
        private String xgxlMediaType;
            @ApiModelProperty(value = "悬挂系统悬挂介质数量")
        private Integer xgxlMediaNumber;
            @ApiModelProperty(value = "悬挂系统悬挂介质型号")
        private String xgxlMediaModel;
            @ApiModelProperty(value = "悬挂系统悬挂介质规格")
        private String xgxlMediaSpecification;
            @ApiModelProperty(value = "驱动主机型号")
        private String qdzjModel;
            @ApiModelProperty(value = "驱动主机产品编号")
        private String qdzjProductNo;
            @ApiModelProperty(value = "驱动主机制造单位")
        private String qdzjManufacturer;
            @ApiModelProperty(value = "控制柜型号")
        private String kzgModel;
            @ApiModelProperty(value = "控制柜产品编号")
        private String kzgProductNo;
            @ApiModelProperty(value = "控制柜制造单位")
        private String kzgManufacturer;
            @ApiModelProperty(value = "限速器型号")
        private String xsqModel;
            @ApiModelProperty(value = "限速器产品编号")
        private String xsqProductNo;
            @ApiModelProperty(value = "限速器制造单位")
        private String xsqManufacturer;
            @ApiModelProperty(value = "安全钳型号")
        private String aqqModel;
            @ApiModelProperty(value = "安全钳产品编号")
        private String aqqProductNo;
            @ApiModelProperty(value = "安全钳制造单位")
        private String aqqManufacturer;
            @ApiModelProperty(value = "轿厢缓冲器型号")
        private String jxhcqModel;
            @ApiModelProperty(value = "轿厢缓冲器产品编号")
        private String jxhcqProductNo;
            @ApiModelProperty(value = "轿厢缓冲器制造单位")
        private String jxhcqManufacturer;
            @ApiModelProperty(value = "对重缓冲器型号")
        private String dchcqModel;
            @ApiModelProperty(value = "对重缓冲器产品编号")
        private String dchcqProductNo;
            @ApiModelProperty(value = "对重缓冲器制造单位")
        private String dchcqManufacturer;
            @ApiModelProperty(value = "层门门锁装置型号")
        private String cmmszzModel;
            @ApiModelProperty(value = "层门门锁装置产品编号")
        private String cmmszzProductNo;
            @ApiModelProperty(value = "层门门锁装置制造单位")
        private String cmmszzManufacturer;
            @ApiModelProperty(value = "轿门门锁装置型号")
        private String jmmszzModel;
            @ApiModelProperty(value = "轿门门锁装置产品编号")
        private String jmmszzProductNo;
            @ApiModelProperty(value = "轿门门锁装置制造单位")
        private String jmmszzManufacturer;
            @ApiModelProperty(value = "上行超速保护装置型号")
        private String sxcsbhzzModel;
            @ApiModelProperty(value = "上行超速保护装置产品编号")
        private String sxcsbhzzProductNo;
            @ApiModelProperty(value = "上行超速保护装置制造单位")
        private String sxcsbhzzManufacturer;
            @ApiModelProperty(value = "轿厢意外移动保护装置型号")
        private String jxywydbhzzModel;
            @ApiModelProperty(value = "轿厢意外移动保护装置")
        private String jxywydbhzzProductNo;
            @ApiModelProperty(value = "轿厢意外移动保护装置制造单位")
        private String jxywydbhzzManufacturer;
            @ApiModelProperty(value = "液压泵站型号")
        private String yybzModel;
            @ApiModelProperty(value = "液压泵站产品编号")
        private String yybzProductNo;
            @ApiModelProperty(value = "液压泵站制造单位")
        private String yybzManufacturer;
            @ApiModelProperty(value = "限速切断阀型号")
        private String xsqdfModel;
            @ApiModelProperty(value = "限速切断阀产品编号")
        private String xsqdfProductNo;
            @ApiModelProperty(value = "限速切断阀制造单位")
        private String xsqdfManufacturer;
            @ApiModelProperty(value = "名义速度")
        private BigDecimal nominalSpeed;
            @ApiModelProperty(value = "倾斜角")
        private BigDecimal angleRoll;
            @ApiModelProperty(value = "名义宽度")
        private BigDecimal nominalWidth;
            @ApiModelProperty(value = "使用区段长度")
        private BigDecimal useSectionLength;
            @ApiModelProperty(value = "输送能力")
        private String conveyingCapacity;
            @ApiModelProperty(value = "工作类型")
        private String workType;
            @ApiModelProperty(value = "工作环境")
        private String workEnvironment;
            @ApiModelProperty(value = "控制柜节能运行方式")
        private String kzgOperationMode;

    
}
