package com.yeejoin.amos.boot.module.jyjc.biz.event.rule;

import com.yeejoin.amos.boot.module.jyjc.biz.event.IRuleDataPrepare;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionOrgRefreshEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.rule.service.DisableRuleDataPreparationService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
public class DisableRuleDataPrepareHandler implements IRuleDataPrepare {

    private final DisableRuleDataPreparationService preparationService;

    @Override
    public Boolean supportType() {
        return false;
    }

    @Override
    public void handle(InspectionOrgRefreshEvent event) {
        preparationService.onApplicationEvent(event);
    }
}
