package com.yeejoin.precontrol.common.controller;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import com.yeejoin.precontrol.common.entity.publics.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.precontrol.common.service.IAppMenuConfigService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.AppMenuConfig;
import com.yeejoin.precontrol.common.utils.NameUtils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;

/**
 * 用户app菜单配置表
 *
 * @author duanwei
 * @date 2021-02-22
 */
@RestController
@Api(tags = "用户app菜单配置表Api")
@RequestMapping(value = "/app-menu-config", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AppMenuConfigController {

	@Autowired
	IAppMenuConfigService iAppMenuConfigService;

	/**
	 * 新增用户app菜单配置表
	 *
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增用户app菜单配置表", notes = "新增用户app菜单配置表")
	public boolean saveAppMenuConfig(HttpServletRequest request, @RequestBody AppMenuConfig appMenuConfig) {
		return iAppMenuConfigService.save(appMenuConfig);
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iAppMenuConfigService.removeById(id);
	}

	/**
	 * 修改用户app菜单配置表
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改用户app菜单配置表", notes = "修改用户app菜单配置表")
	public boolean updateByIdAppMenuConfig(HttpServletRequest request, @RequestBody AppMenuConfig appMenuConfig) {
		return iAppMenuConfigService.updateById(appMenuConfig);
	}

	/**
	 * 根据id查询
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public AppMenuConfig selectById(HttpServletRequest request, @PathVariable Long id) {
		return iAppMenuConfigService.getById(id);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<AppMenuConfig> listPage(String pageNum, String pageSize, AppMenuConfig appMenuConfig) {

		Page<AppMenuConfig> pageBean;
		QueryWrapper<AppMenuConfig> appMenuConfigQueryWrapper = new QueryWrapper<>();
		Class<? extends AppMenuConfig> aClass = appMenuConfig.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(appMenuConfig);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(appMenuConfig);
						appMenuConfigQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(appMenuConfig);
						appMenuConfigQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(appMenuConfig);
						appMenuConfigQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(appMenuConfig);
						appMenuConfigQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<AppMenuConfig> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iAppMenuConfigService.page(pageBean, appMenuConfigQueryWrapper);
		return page;
	}

	@GetMapping("/syncUserAppMenu")
	public Map<String, Boolean> syncUserAppMenu() {
		return iAppMenuConfigService.syncUserAppMenu();
	}

	@GetMapping("/updateUserAppMenu")
	public Map<String, Boolean> updateUserAppMenu(Long id) {
		return iAppMenuConfigService.updateUserAppMenu(id);
	}
}
