package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.Reward;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.precontrol.common.vo.RewardAndRetributionListVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;
import com.yeejoin.precontrol.common.vo.RewardOrgCodeVo;
import com.yeejoin.precontrol.common.vo.RewardVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 奖励表 Mapper 接口
 *
 * @author duanwei
 * @date 2021-04-06
 */
public interface RewardMapper extends BaseMapper<Reward> {

    IPage<RewardVo> pageList(Page page, @Param("reward") RewardVo rewardVo);

    IPage<RewardVo> pageUserInfo(Page page, @Param("reward") RewardVo rewardVo);

    IPage<RewardVo> listPageByUid(Page page, @Param("reward") RewardVo rewardVo);

    RewardVo getRewardExchangeCount(@Param("reward") RewardVo rewardVo);

    String selectTotalMoney(@Param("personId") Long personId);

    IPage<RewardOrgCodeVo> listPageByOrgCode(Page<RewardOrgCodeVo> page, @Param("rewardOrgCodeVo") RewardOrgCodeVo rewardOrgCodeVo, @Param("orgCode") String orgCode);

    IPage<RewardOrgCodeVo> listBadPageByOrgCode(Page<RewardOrgCodeVo> page, @Param("rewardOrgCodeVo") RewardOrgCodeVo rewardOrgCodeVo, @Param("orgCode") String orgCode);

    IPage<RewardListVo> rewardUserListDetail(Page<RewardListVo> page, @Param("rewardOrgCodeVo") RewardListVo rewardVo);

    String selectAllMoneyTotal();

    String selectDayMoneyTotal();

    IPage<RewardAndRetributionListVo> rewardAndRetributionList(Page<RewardAndRetributionListVo> objectPage, @Param("rewardVo") RewardAndRetributionListVo rewardVo);

    Map sumMoneyTotalByPersonId(@Param("personId") Long personId);

    Integer dayCountByOrgCode(@Param("orgCode") String orgCode, @Param("projectId") Long projectId);

    List<RewardVo> rewardAllList(@Param("reward") RewardVo rewardVo);
}
