package com.yeejoin.equipmanage.fegin;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @author DELL
 */
//@FeignClient(name = "AMOS-API-IOT", path = "iot", configuration = {
		//FeignConfiguration.class }, url = "http://39.98.224.23:33001")
@FeignClient(name = "AMOS-API-IOT", path = "iot", configuration = {
		FeignConfiguration.class })
public interface IotFeign {

	@RequestMapping(value = "/v1/livedata/list", method = RequestMethod.GET, consumes = "application/json")
	ResponseModel selectList(@RequestHeader("appKey") String appKey, @RequestHeader("product") String product,
			@RequestHeader("token") String token, @RequestParam(value = "timeStart") String beginDate,
			@RequestParam(value = "timeEnd") String endDate, @RequestParam(value = "productKey") String productKey,
			@RequestParam(value = "deviceName") String deviceName,
			@RequestParam(required = false, value = "fieldKey") String fieldKey);

	@RequestMapping(value = "/v1/livedata/page", method = RequestMethod.GET, consumes = "application/json")
	ResponseModel selectPage(@RequestHeader("appKey") String appKey, @RequestHeader("product") String product,
			@RequestHeader("token") String token, @RequestParam(value = "timeStart") String beginDate,
			@RequestParam(value = "timeEnd") String endDate, @RequestParam(value = "productKey") String productKey,
			@RequestParam(value = "deviceName") String deviceName,
			@RequestParam(required = false, value = "fieldKey") String fieldKey,
			@RequestParam(value = "current") Integer current, @RequestParam(value = "size") Integer size);

	@RequestMapping(value = "v1/livedata/common/top", method = RequestMethod.GET, consumes = "application/json")
	ResponseModel selectOne(@RequestHeader("appKey") String appKey, @RequestHeader("product") String product,
			@RequestHeader("token") String token, @RequestParam(value = "top") String top,
			@RequestParam(value = "productKey") String productKey,
			@RequestParam(value = "deviceName") String deviceName, @RequestParam("FHS_FirePump_RunStatus") String key,
			@RequestParam(required = false, value = "fieldKey") String fieldKey);

	@GetMapping("/v1/livedata/common/list")
	ResponseModel<List<Object>> getLiveData(@RequestParam("measurement") String measurement,
			@RequestParam("deviceName") String deviceName,
			@RequestParam("timeStart") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date timeStart,
			@RequestParam("timeEnd") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")Date timeEnd);
}
