package com.yeejoin.equipmanage.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.WlCarMileage;
import com.yeejoin.equipmanage.controller.Coordinate;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.mapper.WlCarMileageMapper;
import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.IWlCarMileageService;

/**
 * 车量里程表 服务实现类
 *
 * @author duanwei
 * @date 2023-02-01
 */
@Service
public class WlCarMileageServiceImpl extends ServiceImpl<WlCarMileageMapper, WlCarMileage>
		implements IWlCarMileageService {

	@Autowired
	IotFeign iotFeign;

	@Autowired
	ICarService iCarService;

	@Override
	public Page<WlCarMileage> page(Page<WlCarMileage> page, WlCarMileage wlCarMileage) {
		return this.baseMapper.page(page, wlCarMileage);
	}

	@Override
	public Integer totalMileage(String iotCode) {
		return this.baseMapper.totalMileage(iotCode);
	}

	@Override
	public List<Coordinate> getCoordinateList(long id) {
		WlCarMileage wlCarMileage = this.getById(id);
		String iotCode = wlCarMileage.getIotCode();
		String measurement = "0THMcLKR";
		String deviceName = iotCode.replace(measurement, "");
		// 由于iot存在毫秒故结束时间要+1秒 iot+1秒有bug还是查不到 +2秒
		ResponseModel<List<Object>> result = iotFeign.getLiveData(measurement, deviceName, wlCarMileage.getStartTime(),
				new Date(wlCarMileage.getEndTime().getTime()));
		List<Object> list = result.getResult();
		List<Coordinate> coordinateList = new ArrayList<Coordinate>();
		if (list != null) {
			for (Object object : list) {
				JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(object));
				if (jsonObject.get("FireCar_Longitude") != null && jsonObject.get("FireCar_Latitude") != null) {
					Coordinate coordinate = new Coordinate();
					List<Double> lnglat = new ArrayList<Double>();
					lnglat.add(jsonObject.getDoubleValue("FireCar_Longitude"));
					lnglat.add(jsonObject.getDoubleValue("FireCar_Latitude"));
					coordinate.setLnglat(lnglat);
					coordinate.setSpeed(jsonObject.getIntValue("FireCar_Speed"));
					coordinateList.add(coordinate);
				}
			}
		}
		// 倒序坐标变为正序
		Collections.reverse(coordinateList);
		return coordinateList;
	}

	@Override
	public Map<String, Boolean> getCalender(long id, Date date) {
		List<String> daylist = new ArrayList<String>();
		Map<String, Boolean> map =new  HashMap<>();
		Car car = iCarService.getById(id);
		if (car == null || car.getIotCode() == null || date == null) {
			return map;
		}
		Calendar c = Calendar.getInstance();
		// 获取上一个月
		c.setTime(date);
		c.add(Calendar.MONTH, -1);
		daylist.addAll(getDayByMonth(c.getTime()));

		// 获取当月
		c.setTime(date);
		daylist.addAll(getDayByMonth(c.getTime()));

		// 获取下一个月
		c.setTime(date);
		c.add(Calendar.MONTH, 1);
		daylist.addAll(getDayByMonth(c.getTime()));
		List<Map<String, Object>> hasList = this
				.listMaps(new QueryWrapper<WlCarMileage>().select("COUNT(1) AS count,date").lambda().eq(WlCarMileage::getIotCode, car.getIotCode())
						.between(WlCarMileage::getDate, daylist.get(0), daylist.get(daylist.size() - 1))
						.groupBy(WlCarMileage::getDate));
		Map<String, Object> hasMap = new HashMap<>();
		for (Map<String, Object> mapOne : hasList) {
			hasMap.put(String.valueOf(mapOne.get("date")), mapOne.get("count"));
		}
		for (String day : daylist) {
			boolean has = false;
			if (hasMap.containsKey(day)) {
				has = true;
			}
			map.put(day, has);
		}
		return map;
	}

	public static List<String> getDayByMonth(Date date) {
		List<String> data = new ArrayList<>();
		try {
			Calendar c = Calendar.getInstance();
			c.setTime(date);
			// 获取当前的年份
			int year = c.get(Calendar.YEAR);
			// 获取当前的月份（需要加1才是现在的月份）
			int month = c.get(Calendar.MONTH) + 1;
			// 获取本月的总天数
			int dayCount = c.getActualMaximum(Calendar.DAY_OF_MONTH);
			// 定义时间格式
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			// 开始日期为当前年月拼接1号
			Date startDate = sdf.parse(year + "-" + month + "-01");
			// 结束日期为当前年月拼接该月最大天数
			Date endDate = sdf.parse(year + "-" + month + "-" + dayCount);
			// 设置calendar的开始日期
			c.setTime(startDate);
			// 当前时间小于等于设定的结束时间
			while (c.getTime().compareTo(endDate) <= 0) {
				String time = sdf.format(c.getTime());
				data.add(time);
				// 当前日期加1
				c.add(Calendar.DATE, 1);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return data;
	}

}
