package com.yeejoin.precontrol.common.enums;

public enum TaskCurrentStatusEnum {

	PROGRESS(0, "进行中"),

	OVERTIME(1, "超时"),

	UNCOMPLETE(2, "未完成");

	private int type;

	private String name;

	TaskCurrentStatusEnum(int type, String name) {
		this.type = type;
		this.name = name;
	}

	public int getType() {
		return type;
	}

	public long getLongValue() {
		return Long.valueOf(type);
	}

	public String getName() {
		return name;
	}

	public static String getNameByType(int type) {
		String name = null;
		for (TaskCurrentStatusEnum enumOne : TaskCurrentStatusEnum.values()) {
			if (enumOne.getType() == type) {
				name = enumOne.getName();
				break;
			}
		}
		return name;
	}
}
