package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @author ZeHua Li
 * @date 2020/10/29 14:26
 * @since v2.0
 */
@RestController
@Api(tags = "设备报警日志信息")
@RequestMapping(value = "/equipSpecificAlarmLog")
public class EquipmentSpecificAlarmLogController extends AbstractBaseController {

    @Autowired
    IEquipmentSpecificAlarmLogService equipmentSpecificAlarmLogService;


    /**
     * 获取告警设备日月环比信息
     *
     * @param date
     * @return
     */
    @RequestMapping(value = "/equipAlarmLink", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取告警设备日月环比信息", notes = "获取告警设备日月环比信息")
    public ResponseModel equipAlarmLink(@RequestParam(required = false) String date) {
        return CommonResponseUtil.success(equipmentSpecificAlarmLogService.equipAlarmLink(date));
    }


}






