package com.yeejoin.equipmanage.fegin;

import com.alibaba.fastjson.JSONObject;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * @author DELL
 */
@Slf4j
public class FeignErrorDecoder implements ErrorDecoder {

    @Override
    public Exception decode(String methodKey, Response response) {
        String msg = null;
        try {
            msg = Util.toString(response.body().asReader(Util.UTF_8));
            JSONObject object = JSONObject.parseObject(msg);
            throw new RuntimeException(object.get("devMessage").toString());
        } catch (IOException e) {
            log.error("feign 调用失败" + e.getMessage());
        }
        throw new RuntimeException(methodKey + "远程调用失败");
    }
}
