package com.yeejoin.equipmanage.service;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemGroupEntity;
import com.yeejoin.equipmanage.common.entity.dto.FireFightingSystemGroupModalDto;

import java.util.List;

public interface FireFightingSystemGroupService extends IService<FireFightingSystemGroupEntity> {

    /**
     * 获取未绑定分组的系统列表
     */
    JSONArray selectUnboundSystems(String bizOrgCode);
    /**
     * 保存分组
     *
     * @param fireFightingSystemGroupModalDto 分组信息
     */
    Boolean saveOrUpdate(FireFightingSystemGroupModalDto fireFightingSystemGroupModalDto);

    /**
     * 更新分组排序
     */
    void updateGroupSort(List<Long> groupIds);

    /**
     * 更新系统排序
     */
    void updateSystemSort(Long groupId, List<Long> systemIds);

    /**
     * 获取分组
     *
     * @param bizOrgCode 业务组织编码
     * @return 分组列表
     */
    JSONArray listGroup(String bizOrgCode);

    /**
     * 删除分组
     */
    void deleteGroup(Long groupId);
}
